/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.PrivateClassLoader;
import mx4j.ImplementationException;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.DefaultClassLoaderRepository;
import mx4j.server.DefaultMBeanRepository;
import mx4j.server.MBeanIntrospector;
import mx4j.server.MBeanMetaData;
import mx4j.server.MBeanRepository;
import mx4j.server.ModifiableClassLoaderRepository;
import mx4j.server.interceptor.ContextClassLoaderMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfigurator;
import mx4j.server.interceptor.NotificationListenerMBeanServerInterceptor;
import mx4j.server.interceptor.SecurityMBeanServerInterceptor;
import mx4j.util.Utils;

public class MX4JMBeanServer
implements MBeanServer {
    private String defaultDomain;
    private MBeanRepository mbeanRepository;
    private MBeanServerDelegate delegate;
    private ObjectName delegateName;
    private MBeanIntrospector introspector;
    private MBeanServerInterceptorConfigurator invoker;
    private static long notifications;
    private ModifiableClassLoaderRepository classLoaderRepository;
    private Map domains = new HashMap();
    private static final String[] EMPTY_PARAMS;
    private static final Object[] EMPTY_ARGS;
    static /* synthetic */ Class class$mx4j$server$MX4JMBeanServer;

    public MX4JMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        SecurityManager sm;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Creating MBeanServer instance...");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking permission to create MBeanServer...");
            }
            sm.checkPermission(new MBeanServerPermission("newMBeanServer"));
        }
        if (defaultDomain == null) {
            defaultDomain = "";
        }
        this.defaultDomain = defaultDomain;
        if (delegate == null) {
            throw new JMRuntimeException("Delegate can't be null");
        }
        this.delegate = delegate;
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer default domain is: '" + this.defaultDomain + "'");
        }
        this.mbeanRepository = this.createMBeanRepository();
        this.classLoaderRepository = this.createClassLoaderRepository();
        this.classLoaderRepository.addClassLoader(this.getClass().getClassLoader());
        this.classLoaderRepository.addClassLoader(ClassLoader.getSystemClassLoader());
        this.introspector = new MBeanIntrospector();
        try {
            this.delegateName = new ObjectName("JMImplementation", "type", "MBeanServerDelegate");
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        try {
            ObjectName invokerName = new ObjectName("JMImplementation:type=MBeanServerInterceptorConfigurator");
            this.invoker = new MBeanServerInterceptorConfigurator(this);
            ContextClassLoaderMBeanServerInterceptor ccl = new ContextClassLoaderMBeanServerInterceptor();
            NotificationListenerMBeanServerInterceptor notif = new NotificationListenerMBeanServerInterceptor();
            SecurityMBeanServerInterceptor sec = new SecurityMBeanServerInterceptor();
            InvokerMBeanServerInterceptor inv = new InvokerMBeanServerInterceptor(outer == null ? this : outer);
            this.invoker.addPreInterceptor(ccl);
            this.invoker.addPreInterceptor(notif);
            this.invoker.addPreInterceptor(sec);
            this.invoker.addPostInterceptor(inv);
            this.invoker.start();
            this.privilegedRegisterMBean(this.invoker, invokerName);
            ObjectName cclName = new ObjectName("JMImplementation", "interceptor", "contextclassloader");
            ObjectName notifName = new ObjectName("JMImplementation", "interceptor", "notificationwrapper");
            ObjectName secName = new ObjectName("JMImplementation", "interceptor", "security");
            ObjectName invName = new ObjectName("JMImplementation", "interceptor", "invoker");
            this.privilegedRegisterMBean(ccl, cclName);
            this.privilegedRegisterMBean(notif, notifName);
            this.privilegedRegisterMBean(sec, secName);
            this.privilegedRegisterMBean(inv, invName);
        }
        catch (Exception x) {
            logger.error("MBeanServerInterceptorConfigurator cannot be registered", x);
            throw new ImplementationException();
        }
        try {
            this.privilegedRegisterMBean(delegate, this.delegateName);
        }
        catch (Exception x) {
            logger.error("MBeanServerDelegate cannot be registered", x);
            throw new ImplementationException(x.toString());
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer instance created successfully");
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission("-#-[-]", "getClassLoaderRepository"));
        }
        return this.getModifiableClassLoaderRepository();
    }

    private ModifiableClassLoaderRepository getModifiableClassLoaderRepository() {
        return this.classLoaderRepository;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if ((name = this.secureObjectName(name)) == null) {
                sm.checkPermission(new MBeanPermission("-#-[-]", "getClassLoader"));
            } else {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", name, "getClassLoader"));
            }
        }
        return this.getClassLoaderImpl(name);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            name = this.secureObjectName(name);
        }
        MBeanMetaData metadata = this.findMBeanMetaData(name);
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", name, "getClassLoaderFor"));
        }
        return metadata.getMBean().getClass().getClassLoader();
    }

    private ClassLoader getClassLoaderImpl(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            return this.getClass().getClassLoader();
        }
        MBeanMetaData metadata = this.findMBeanMetaData(name);
        if (metadata.getMBean() instanceof ClassLoader) {
            return (ClassLoader)metadata.getMBean();
        }
        throw new InstanceNotFoundException(name.getCanonicalName());
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name '" + className + "'"));
        }
        ClassLoader cl = this.getClassLoader(loaderName);
        try {
            Class<?> cls = cl.loadClass(className);
            return this.deserializeImpl(cls.getClassLoader(), bytes);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInputStream deserialize(String className, byte[] bytes) throws OperationsException, ReflectionException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name '" + className + "'"));
        }
        try {
            Class<?> cls = this.getClassLoaderRepository().loadClass(className);
            return this.deserializeImpl(cls.getClassLoader(), bytes);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        ClassLoader cl = this.getClassLoaderFor(objectName);
        return this.deserializeImpl(cl, bytes);
    }

    private ObjectInputStream deserializeImpl(ClassLoader classloader, byte[] bytes) throws OperationsException {
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid byte array " + bytes));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            return new ClassLoaderObjectInputStream(bais, classloader);
        }
        catch (IOException x) {
            throw new OperationsException(x.toString());
        }
    }

    private MBeanServerInterceptor getHeadInterceptor() {
        MBeanServerInterceptor head = this.invoker.getHeadInterceptor();
        if (head == null) {
            throw new IllegalStateException("No MBeanServer interceptor, probably the configurator has been stopped");
        }
        return head;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private MBeanRepository createMBeanRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom MBeanServer registry; class is: " + value);
                }
                try {
                    MBeanRepository registry = (MBeanRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom MBeanServer registry created successfully");
                    }
                    return registry;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom MBeanServer registry could not be created", x);
                }
            }
        }
        return new DefaultMBeanRepository();
    }

    private ModifiableClassLoaderRepository createClassLoaderRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.classloader.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.classloader.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom ClassLoaderRepository; class is: " + value);
                }
                try {
                    ModifiableClassLoaderRepository repository = (ModifiableClassLoaderRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom ClassLoaderRepository created successfully " + repository);
                    }
                    return repository;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom ClassLoaderRepository could not be created", x);
                }
            }
        }
        return new DefaultClassLoaderRepository();
    }

    private MBeanRepository getMBeanRepository() {
        return this.mbeanRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanMetaData findMBeanMetaData(ObjectName objectName) throws InstanceNotFoundException {
        MBeanMetaData metadata = null;
        if (objectName != null) {
            MBeanRepository repository;
            objectName = this.normalizeObjectName(objectName);
            MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
            synchronized (mBeanRepository) {
                metadata = repository.get(objectName);
            }
        }
        if (metadata == null) {
            throw new InstanceNotFoundException("MBeanServer cannot find MBean with ObjectName " + objectName);
        }
        return metadata;
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Object mbean = this.findMBeanMetaData(listener = this.secureObjectName(listener)).getMBean();
        if (!(mbean instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + listener + " is not a NotificationListener"));
        }
        this.addNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed = this.secureObjectName(observed));
        Object mbean = metadata.getMBean();
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + observed + " is not a NotificationBroadcaster"));
        }
        this.addNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void addNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        this.getHeadInterceptor().addNotificationListener(metadata, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Object mbean = this.findMBeanMetaData(listener = this.secureObjectName(listener)).getMBean();
        if (!(mbean instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + listener + " is not a NotificationListener"));
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed = this.secureObjectName(observed));
        Object mbean = metadata.getMBean();
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + observed + " is not a NotificationBroadcaster"));
        }
        this.removeNotificationListenerImpl(metadata, listener);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Object mbean = this.findMBeanMetaData(listener = this.secureObjectName(listener)).getMBean();
        if (!(mbean instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + listener + " is not a NotificationListener"));
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed = this.secureObjectName(observed));
        Object mbean = metadata.getMBean();
        if (!(mbean instanceof NotificationEmitter)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + observed + " is not a NotificationEmitter"));
        }
        this.removeNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void removeNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        this.getHeadInterceptor().removeNotificationListener(metadata, listener);
    }

    private void removeNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getHeadInterceptor().removeNotificationListener(metadata, listener, filter, handback);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, null, null);
    }

    public Object instantiate(String className, Object[] args, String[] parameters) throws ReflectionException, MBeanException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        try {
            Class<?> cls = this.getModifiableClassLoaderRepository().loadClass(className);
            return this.instantiateImpl(className, cls.getClassLoader(), null, parameters, args).getMBean();
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        if ((loaderName = this.secureObjectName(loaderName)) != null && loaderName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName for the ClassLoader cannot be a pattern ObjectName: " + loaderName));
        }
        ClassLoader cl = this.getClassLoaderImpl(loaderName);
        return this.instantiateImpl(className, cl, null, parameters, args).getMBean();
    }

    private MBeanMetaData instantiateImpl(String className, ClassLoader classloader, ObjectName name, String[] params, Object[] args) throws ReflectionException, MBeanException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        MBeanMetaData metadata = this.createMBeanMetaData();
        metadata.setClassLoader(classloader);
        metadata.setObjectName(this.secureObjectName(name));
        this.getHeadInterceptor().instantiate(metadata, className, params, args);
        return metadata;
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, objectName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Class<?> cls = this.getModifiableClassLoaderRepository().loadClass(className);
            MBeanMetaData metadata = this.instantiateImpl(className, cls.getClassLoader(), objectName, parameters, args);
            this.registerImpl(metadata, false);
            return metadata.getObjectInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, objectName, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        loaderName = this.secureObjectName(loaderName);
        ClassLoader cl = this.getClassLoaderImpl(loaderName);
        MBeanMetaData metadata = this.instantiateImpl(className, cl, objectName, parameters, args);
        this.registerImpl(metadata, false);
        return metadata.getObjectInstance();
    }

    public ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerMBeanImpl(mbean, objectName, false);
    }

    private ObjectInstance registerMBeanImpl(Object mbean, ObjectName objectName, boolean privileged) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (mbean == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean instance cannot be null"));
        }
        MBeanMetaData metadata = this.createMBeanMetaData();
        metadata.setMBean(mbean);
        metadata.setClassLoader(mbean.getClass().getClassLoader());
        metadata.setObjectName(this.secureObjectName(objectName));
        this.registerImpl(metadata, privileged);
        return metadata.getObjectInstance();
    }

    private MBeanMetaData createMBeanMetaData() {
        return MBeanMetaData.Factory.create();
    }

    private ObjectInstance privilegedRegisterMBean(final Object mbean, final ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            return (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MX4JMBeanServer.this.registerMBeanImpl(mbean, name, true);
                }
            });
        }
        catch (PrivilegedActionException x) {
            Exception xx = x.getException();
            if (xx instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)xx;
            }
            if (xx instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)xx;
            }
            if (xx instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)xx;
            }
            throw new MBeanRegistrationException(xx);
        }
    }

    private void registerImpl(MBeanMetaData metadata, boolean privileged) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.introspector.introspect(metadata);
        if (!this.introspector.isMBeanCompliant(metadata)) {
            throw new NotCompliantMBeanException("MBean is not compliant");
        }
        MBeanServerInterceptor head = this.getHeadInterceptor();
        try {
            head.registration(metadata, 1);
            metadata.setObjectName(this.secureObjectName(metadata.getObjectName()));
            this.register(metadata, privileged);
            head.registration(metadata, 2);
        }
        catch (Throwable x) {
            try {
                head.registration(metadata, 3);
            }
            catch (MBeanRegistrationException ignored) {
                // empty catch block
            }
            if (x instanceof SecurityException) {
                throw (SecurityException)x;
            }
            if (x instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)x;
            }
            if (x instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x;
            }
            if (x instanceof RuntimeOperationsException) {
                throw (RuntimeOperationsException)x;
            }
            if (x instanceof JMRuntimeException) {
                throw (JMRuntimeException)x;
            }
            if (x instanceof Exception) {
                throw new MBeanRegistrationException((Exception)x);
            }
            if (x instanceof Error) {
                throw new MBeanRegistrationException(new RuntimeErrorException((Error)x));
            }
            throw new ImplementationException();
        }
        Object mbean = metadata.getMBean();
        if (mbean instanceof ClassLoader && !(mbean instanceof PrivateClassLoader)) {
            ClassLoader cl = (ClassLoader)mbean;
            this.getModifiableClassLoaderRepository().addClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(MBeanMetaData metadata, boolean privileged) throws InstanceAlreadyExistsException {
        MBeanRepository repository;
        metadata.setObjectName(this.normalizeObjectName(metadata.getObjectName()));
        ObjectName objectName = metadata.getObjectName();
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation") && !privileged) {
            throw new JMRuntimeException("Domain 'JMImplementation' is reserved for the JMX Agent");
        }
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            if (repository.get(objectName) != null) {
                throw new InstanceAlreadyExistsException(objectName.toString());
            }
            repository.put(objectName, metadata);
        }
        this.addDomain(objectName.getDomain());
        this.notify(objectName, "JMX.mbean.registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(ObjectName objectName, String notificationType) {
        long sequenceNumber = 0L;
        Class clazz = class$mx4j$server$MX4JMBeanServer == null ? (class$mx4j$server$MX4JMBeanServer = MX4JMBeanServer.class$("mx4j.server.MX4JMBeanServer")) : class$mx4j$server$MX4JMBeanServer;
        synchronized (clazz) {
            sequenceNumber = notifications++;
        }
        this.delegate.sendNotification(new MBeanServerNotification(notificationType, (Object)this.delegateName, sequenceNumber, objectName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDomain(String domain) {
        Map map = this.domains;
        synchronized (map) {
            Integer count = (Integer)this.domains.get(domain);
            if (count == null) {
                this.domains.put(domain, new Integer(1));
            } else {
                this.domains.put(domain, new Integer(count + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDomain(String domain) {
        Map map = this.domains;
        synchronized (map) {
            Integer count = (Integer)this.domains.get(domain);
            if (count == null) {
                throw new ImplementationException();
            }
            if (count < 2) {
                this.domains.remove(domain);
            } else {
                this.domains.put(domain, new Integer(count - 1));
            }
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if ((objectName = this.secureObjectName(objectName)) == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Domain 'JMImplementation' is reserved for the JMX Agent"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        try {
            MBeanServerInterceptor head = this.getHeadInterceptor();
            head.registration(metadata, 4);
            this.unregister(metadata);
            this.getHeadInterceptor().registration(metadata, 5);
            Object mbean = metadata.getMBean();
            if (mbean instanceof ClassLoader && !(mbean instanceof PrivateClassLoader)) {
                this.getModifiableClassLoaderRepository().removeClassLoader((ClassLoader)mbean);
            }
        }
        catch (MBeanRegistrationException x) {
            throw x;
        }
        catch (SecurityException x) {
            throw x;
        }
        catch (Exception x) {
            throw new MBeanRegistrationException(x);
        }
        catch (Error x) {
            throw new MBeanRegistrationException(new RuntimeErrorException(x));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(MBeanMetaData metadata) {
        MBeanRepository repository;
        ObjectName objectName = metadata.getObjectName();
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            repository.remove(objectName);
        }
        this.removeDomain(objectName.getDomain());
        this.notify(objectName, "JMX.mbean.unregistered");
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().getAttribute(metadata, attribute);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null || attribute.getName().trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        this.getHeadInterceptor().setAttribute(metadata, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", objectName, "getAttribute"));
        }
        return this.getHeadInterceptor().getAttributes(metadata, attributes);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", objectName, "setAttribute"));
        }
        return this.getHeadInterceptor().setAttributes(metadata, attributes);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid operation name '" + methodName + "'"));
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if (parameters == null) {
            parameters = EMPTY_PARAMS;
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().invoke(metadata, methodName, parameters, args);
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        Map map = this.domains;
        synchronized (map) {
            Set keys = this.domains.keySet();
            return keys.toArray(new String[keys.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMBeanCount() {
        MBeanRepository repository;
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            return new Integer(repository.size());
        }
    }

    public boolean isRegistered(ObjectName objectName) {
        try {
            return this.findMBeanMetaData(objectName) != null;
        }
        catch (InstanceNotFoundException x) {
            return false;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        MBeanInfo info = this.getHeadInterceptor().getMBeanInfo(metadata);
        if (info == null) {
            throw new JMRuntimeException("MBeanInfo returned for MBean " + objectName + " is null");
        }
        return info;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            objectName = this.secureObjectName(objectName);
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", objectName, "getObjectInstance"));
        }
        return metadata.getObjectInstance();
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(metadata.getMBeanInfo().getClassName(), "-", objectName, "isInstanceOf"));
        }
        try {
            ClassLoader loader = metadata.getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> cls = loader.loadClass(className);
            Object mbean = metadata.getMBean();
            if (mbean instanceof StandardMBean) {
                Object impl = ((StandardMBean)mbean).getImplementation();
                return cls.isInstance(impl);
            }
            return cls.isInstance(mbean);
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            patternName = this.secureObjectName(patternName);
            sm.checkPermission(new MBeanPermission("-#-[-]", "queryMBeans"));
        }
        Set match = this.queryObjectNames(patternName, filter, true);
        HashSet<ObjectInstance> set = new HashSet<ObjectInstance>();
        Iterator i = match.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                set.add(metadata.getObjectInstance());
            }
            catch (InstanceNotFoundException ignored) {}
        }
        return set;
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            patternName = this.secureObjectName(patternName);
            sm.checkPermission(new MBeanPermission("-#-[-]", "queryNames"));
        }
        return this.queryObjectNames(patternName, filter, false);
    }

    private Set queryObjectNames(ObjectName patternName, QueryExp filter, boolean instances) {
        Set scope = this.findMBeansByPattern(patternName);
        Set secureScope = this.filterMBeansBySecurity(scope, instances);
        Set match = this.filterMBeansByQuery(secureScope, filter);
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set findMBeansByPattern(ObjectName pattern) {
        MBeanRepository original;
        if (pattern == null) {
            try {
                pattern = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        pattern = this.normalizeObjectName(pattern);
        String patternDomain = pattern.getDomain();
        Hashtable<String, String> patternProps = pattern.getKeyPropertyList();
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        MBeanRepository repository = null;
        MBeanRepository mBeanRepository = original = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            repository = (MBeanRepository)original.clone();
        }
        Iterator i = repository.iterator();
        while (i.hasNext()) {
            MBeanMetaData metadata = (MBeanMetaData)i.next();
            ObjectName name = metadata.getObjectName();
            Hashtable<String, String> props = name.getKeyPropertyList();
            String domain = name.getDomain();
            if (!Utils.wildcardMatch(patternDomain, domain)) continue;
            if (pattern.isPropertyPattern()) {
                if (patternProps.size() == 0) {
                    set.add(name);
                    continue;
                }
                boolean found = true;
                Iterator<Map.Entry<String, String>> j = patternProps.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry<String, String> entry = j.next();
                    String patternKey = entry.getKey();
                    String patternValue = entry.getValue();
                    if (patternKey.equals("*")) continue;
                    if (!props.containsKey(patternKey)) {
                        found = false;
                        break;
                    }
                    String value = props.get(patternKey);
                    if (value == null && patternValue == null || value != null && value.equals(patternValue)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                set.add(name);
                continue;
            }
            if (!((Object)props.entrySet()).equals(patternProps.entrySet())) continue;
            set.add(name);
        }
        return set;
    }

    private Set filterMBeansBySecurity(Set mbeans, boolean instances) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return mbeans;
        }
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Iterator i = mbeans.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                String className = metadata.getMBeanInfo().getClassName();
                sm.checkPermission(new MBeanPermission(className, "-", name, instances ? "queryMBeans" : "queryNames"));
                set.add(name);
            }
            catch (InstanceNotFoundException ignored) {
            }
            catch (SecurityException ignored) {}
        }
        return set;
    }

    private Set filterMBeansByQuery(Set scope, QueryExp filter) {
        if (filter == null) {
            return scope;
        }
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Iterator i = scope.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            filter.setMBeanServer(this);
            try {
                if (!filter.apply(name)) continue;
                set.add(name);
            }
            catch (BadStringOperationException ignored) {
            }
            catch (BadBinaryOpValueExpException ignored) {
            }
            catch (BadAttributeValueExpException x) {
            }
            catch (InvalidApplicationException x) {
            }
            catch (SecurityException x) {
            }
            catch (Exception x) {}
        }
        return set;
    }

    private ObjectName normalizeObjectName(ObjectName name) {
        if (name == null) {
            return null;
        }
        String defaultDomain = this.getDefaultDomain();
        String domain = name.getDomain();
        if (domain.length() == 0 && defaultDomain.length() > 0) {
            StringBuffer buffer = new StringBuffer(defaultDomain).append(":").append(name.getKeyPropertyListString());
            if (name.isPropertyPattern()) {
                if (name.getKeyPropertyList().size() > 0) {
                    buffer.append(",*");
                } else {
                    buffer.append("*");
                }
            }
            try {
                name = new ObjectName(buffer.toString());
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        return name;
    }

    private ObjectName secureObjectName(ObjectName name) {
        if (name == null) {
            return null;
        }
        return ObjectName.getInstance(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_PARAMS = new String[0];
        EMPTY_ARGS = new Object[0];
    }
}

