/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum MethodInvocation {
    VIRTUAL(182, 5),
    INTERFACE(185, 9),
    STATIC(184, 6),
    SPECIAL(183, 7),
    SPECIAL_CONSTRUCTOR(183, 8);

    private final int invocationOpcode;
    private final int handle;

    private MethodInvocation(int callOpcode, int handle) {
        this.invocationOpcode = callOpcode;
        this.handle = handle;
    }

    public static WithImplicitInvocationTargetType invoke(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return IllegalInvocation.INSTANCE;
        }
        if (methodDescription.isStatic()) {
            MethodInvocation methodInvocation = STATIC;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isConstructor()) {
            MethodInvocation methodInvocation = SPECIAL_CONSTRUCTOR;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isPrivate()) {
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.getDeclaringType().isInterface()) {
            MethodInvocation methodInvocation = INTERFACE;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        MethodInvocation methodInvocation = VIRTUAL;
        ((Object)((Object)methodInvocation)).getClass();
        return methodInvocation.new Invocation(methodDescription);
    }

    public static WithImplicitInvocationTargetType invoke(MethodDescription methodDescription) {
        MethodDescription.InDefinedShape declaredMethod = (MethodDescription.InDefinedShape)methodDescription.asDefined();
        return declaredMethod.getReturnType().asErasure().equals(methodDescription.getReturnType().asErasure()) ? MethodInvocation.invoke(declaredMethod) : OfGenericMethod.of(methodDescription, MethodInvocation.invoke(declaredMethod));
    }

    public static enum HandleType {
        EXACT("invokeExact"),
        REGULAR("invoke");

        private final String methodName;

        private HandleType(String methodName) {
            this.methodName = methodName;
        }

        protected String getMethodName() {
            return this.methodName;
        }
    }

    protected static class HandleInvocation
    implements StackManipulation {
        private static final String METHOD_HANDLE = "java/lang/invoke/MethodHandle";
        private final MethodDescription.InDefinedShape methodDescription;
        private final HandleType type;

        protected HandleInvocation(MethodDescription.InDefinedShape methodDescription, HandleType type) {
            this.methodDescription = methodDescription;
            this.type = type;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitMethodInsn(182, METHOD_HANDLE, this.type.getMethodName(), this.methodDescription.isStatic() || this.methodDescription.isConstructor() ? this.methodDescription.getDescriptor() : "(" + this.methodDescription.getDeclaringType().getDescriptor() + this.methodDescription.getDescriptor().substring(1), false);
            int parameterSize = 1 + this.methodDescription.getStackSize();
            int returnValueSize = this.methodDescription.getReturnType().getStackSize().getSize();
            return new StackManipulation.Size(returnValueSize - parameterSize, Math.max(0, returnValueSize - parameterSize));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandleInvocation)) {
                return false;
            }
            HandleInvocation other = (HandleInvocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
            MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
            if (this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription)) {
                return false;
            }
            HandleType this$type = this.type;
            HandleType other$type = other.type;
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HandleInvocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
            result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
            HandleType $type = this.type;
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }
    }

    protected class DynamicInvocation
    implements StackManipulation {
        private final String methodName;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;
        private final MethodDescription.InDefinedShape bootstrapMethod;
        private final List<?> arguments;

        public DynamicInvocation(String methodName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, MethodDescription.InDefinedShape bootstrapMethod, List<?> arguments) {
            this.methodName = methodName;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.bootstrapMethod = bootstrapMethod;
            this.arguments = arguments;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription typeDescription : this.parameterTypes) {
                stringBuilder.append(typeDescription.getDescriptor());
            }
            String methodDescriptor = stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
            methodVisitor.visitInvokeDynamicInsn(this.methodName, methodDescriptor, new Handle(MethodInvocation.this.handle, this.bootstrapMethod.getDeclaringType().getInternalName(), this.bootstrapMethod.getInternalName(), this.bootstrapMethod.getDescriptor(), this.bootstrapMethod.getDeclaringType().isInterface()), this.arguments.toArray(new Object[this.arguments.size()]));
            int n = this.returnType.getStackSize().getSize() - StackSize.of(this.parameterTypes);
            return new StackManipulation.Size(n, Math.max(n, 0));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DynamicInvocation that = (DynamicInvocation)other;
            return MethodInvocation.this == that.getOuter() && this.arguments.equals(that.arguments) && this.bootstrapMethod.equals(that.bootstrapMethod) && this.returnType.equals(that.returnType) && this.parameterTypes.equals(that.parameterTypes) && this.methodName.equals(that.methodName);
        }

        private MethodInvocation getOuter() {
            return MethodInvocation.this;
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + MethodInvocation.this.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            result = 31 * result + this.bootstrapMethod.hashCode();
            result = 31 * result + this.arguments.hashCode();
            return result;
        }
    }

    protected class Invocation
    implements WithImplicitInvocationTargetType {
        private final TypeDescription typeDescription;
        private final MethodDescription.InDefinedShape methodDescription;

        protected Invocation(MethodDescription.InDefinedShape methodDescription) {
            this(methodDescription, methodDescription.getDeclaringType());
        }

        protected Invocation(MethodDescription.InDefinedShape methodDescription, TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
            this.methodDescription = methodDescription;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitMethodInsn(MethodInvocation.this.invocationOpcode, this.typeDescription.getInternalName(), this.methodDescription.getInternalName(), this.methodDescription.getDescriptor(), this.typeDescription.isInterface());
            int parameterSize = this.methodDescription.getStackSize();
            int returnValueSize = this.methodDescription.getReturnType().getStackSize().getSize();
            return new StackManipulation.Size(returnValueSize - parameterSize, Math.max(0, returnValueSize - parameterSize));
        }

        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            if (this.methodDescription.isPrivate() || this.methodDescription.isConstructor() || this.methodDescription.isStatic()) {
                return StackManipulation.Illegal.INSTANCE;
            }
            if (invocationTarget.isInterface()) {
                MethodInvocation methodInvocation = INTERFACE;
                ((Object)((Object)methodInvocation)).getClass();
                return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            }
            MethodInvocation methodInvocation = VIRTUAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            StackManipulation stackManipulation;
            if (this.methodDescription.isSpecializableFor(invocationTarget)) {
                MethodInvocation methodInvocation = SPECIAL;
                ((Object)((Object)methodInvocation)).getClass();
                stackManipulation = methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            } else {
                stackManipulation = StackManipulation.Illegal.INSTANCE;
            }
            return stackManipulation;
        }

        @Override
        public StackManipulation dynamic(String methodName, TypeDescription returnType, List<? extends TypeDescription> methodType, List<?> arguments) {
            return this.methodDescription.isBootstrap() ? new DynamicInvocation(methodName, returnType, new TypeList.Explicit(methodType), (MethodDescription.InDefinedShape)this.methodDescription.asDefined(), arguments) : StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation onHandle(HandleType type) {
            return new HandleInvocation(this.methodDescription, type);
        }

        private MethodInvocation getOuterInstance() {
            return MethodInvocation.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Invocation that = (Invocation)other;
            return MethodInvocation.this.equals((Object)((Invocation)other).getOuterInstance()) && this.methodDescription.asSignatureToken().equals(that.methodDescription.asSignatureToken()) && this.typeDescription.equals(that.typeDescription);
        }

        public int hashCode() {
            int result = this.typeDescription.hashCode();
            result = 31 * result + MethodInvocation.this.hashCode();
            result = 31 * result + this.methodDescription.asSignatureToken().hashCode();
            return result;
        }
    }

    protected static class OfGenericMethod
    implements WithImplicitInvocationTargetType {
        private final TypeDescription targetType;
        private final WithImplicitInvocationTargetType invocation;

        protected OfGenericMethod(TypeDescription targetType, WithImplicitInvocationTargetType invocation) {
            this.targetType = targetType;
            this.invocation = invocation;
        }

        protected static WithImplicitInvocationTargetType of(MethodDescription methodDescription, WithImplicitInvocationTargetType invocation) {
            return new OfGenericMethod(methodDescription.getReturnType().asErasure(), invocation);
        }

        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            return new StackManipulation.Compound(this.invocation.virtual(invocationTarget), TypeCasting.to(this.targetType));
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            return new StackManipulation.Compound(this.invocation.special(invocationTarget), TypeCasting.to(this.targetType));
        }

        @Override
        public StackManipulation dynamic(String methodName, TypeDescription returnType, List<? extends TypeDescription> methodType, List<?> arguments) {
            return this.invocation.dynamic(methodName, returnType, methodType, arguments);
        }

        @Override
        public StackManipulation onHandle(HandleType type) {
            return new StackManipulation.Compound(this.invocation.onHandle(type), TypeCasting.to(this.targetType));
        }

        @Override
        public boolean isValid() {
            return this.invocation.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return new StackManipulation.Compound(this.invocation, TypeCasting.to(this.targetType)).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfGenericMethod)) {
                return false;
            }
            OfGenericMethod other = (OfGenericMethod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDescription this$targetType = this.targetType;
            TypeDescription other$targetType = other.targetType;
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            WithImplicitInvocationTargetType this$invocation = this.invocation;
            WithImplicitInvocationTargetType other$invocation = other.invocation;
            return !(this$invocation == null ? other$invocation != null : !this$invocation.equals(other$invocation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OfGenericMethod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDescription $targetType = this.targetType;
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            WithImplicitInvocationTargetType $invocation = this.invocation;
            result = result * 59 + ($invocation == null ? 43 : $invocation.hashCode());
            return result;
        }
    }

    public static interface WithImplicitInvocationTargetType
    extends StackManipulation {
        public StackManipulation virtual(TypeDescription var1);

        public StackManipulation special(TypeDescription var1);

        public StackManipulation dynamic(String var1, TypeDescription var2, List<? extends TypeDescription> var3, List<?> var4);

        public StackManipulation onHandle(HandleType var1);
    }

    protected static enum IllegalInvocation implements WithImplicitInvocationTargetType
    {
        INSTANCE;


        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation dynamic(String methodName, TypeDescription returnType, List<? extends TypeDescription> methodType, List<?> arguments) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation onHandle(HandleType type) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }
    }
}

