/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.guerlab.loadbalancer.ILoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;

public abstract class AbstractLoadBalancer<T, C>
implements ILoadBalancer<T, C> {
    protected final List<TargetWrapper<T>> targetList;

    public AbstractLoadBalancer() {
        this(new CopyOnWriteArrayList<TargetWrapper<T>>());
    }

    public AbstractLoadBalancer(List<TargetWrapper<T>> targetList) {
        this.targetList = targetList;
    }

    @Override
    public void addTargetWrapper(TargetWrapper<T> wrapper) {
        if (wrapper == null) {
            return;
        }
        if (!this.targetList.contains(wrapper)) {
            this.targetList.add(wrapper);
            this.afterAdd(wrapper);
        }
    }

    protected void afterAdd(TargetWrapper<T> wrapper) {
    }

    @Override
    public void removeTargetWrapper(TargetWrapper<T> wrapper) {
        if (wrapper == null) {
            return;
        }
        this.targetList.remove(wrapper);
        this.afterRemove(wrapper);
    }

    protected void afterRemove(TargetWrapper<T> wrapper) {
    }

    @Override
    public void clear() {
        this.targetList.clear();
    }

    @Override
    public void setWeight(T target, int weight) {
    }

    @Override
    public T choose(Predicate<? super T> predicate, C chooseReferenceObject) {
        List<TargetWrapper<T>> activeTargetList = predicate == null ? this.targetList.stream().filter(TargetWrapper::isActive).collect(Collectors.toList()) : this.targetList.stream().filter(TargetWrapper::isActive).filter(wrapper -> predicate.test((Object)wrapper.getTarget())).collect(Collectors.toList());
        if (activeTargetList.isEmpty()) {
            return null;
        }
        return this.choose0(activeTargetList, chooseReferenceObject);
    }

    protected abstract T choose0(List<TargetWrapper<T>> var1, C var2);

    @Override
    public void markReachable(TargetWrapper<T> wrapper) {
        if (wrapper == null) {
            return;
        }
        this.targetList.stream().filter(wrapper::equals).forEach(item -> item.setActive(true));
    }

    @Override
    public void markDown(TargetWrapper<T> wrapper) {
        if (wrapper == null) {
            return;
        }
        this.targetList.stream().filter(wrapper::equals).forEach(item -> item.setActive(false));
    }

    @Override
    public List<TargetWrapper<T>> getTargetWrappers(Boolean active) {
        List<TargetWrapper<T>> wrappers = active == null ? this.targetList : this.targetList.stream().filter(wrapper -> wrapper.isActive() == active.booleanValue()).collect(Collectors.toList());
        return Collections.unmodifiableList(wrappers);
    }

    @Override
    public List<T> getTargets(Boolean active) {
        List targets = active == null ? this.targetList.stream().map(TargetWrapper::getTarget).collect(Collectors.toList()) : this.targetList.stream().filter(wrapper -> wrapper.isActive() == active.booleanValue()).map(TargetWrapper::getTarget).collect(Collectors.toList());
        return Collections.unmodifiableList(targets);
    }
}

