/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.intelie.pipes.Row;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.PipesComparator;

public abstract class AbstractRow
implements Row {
    private static final long serialVersionUID = 1L;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRow)) {
            return false;
        }
        AbstractRow row = (AbstractRow)o;
        return Iterables.equals(this, row);
    }

    @Override
    public int compareTo(Row other) {
        int size = Math.min(this.size(), other.size());
        for (int i = 0; i < size; ++i) {
            int temp = PipesComparator.instance().compare(this.get(i), other.get(i));
            if (temp == 0) continue;
            return temp;
        }
        return Integer.compare(this.size(), other.size());
    }

    public int hashCode() {
        return Iterables.hash(this);
    }

    public String toString() {
        return "[" + Iterables.join(", ", this) + "]";
    }

    @Override
    public Iterator<Object> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int current = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < AbstractRow.this.size();
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            return AbstractRow.this.get(this.current++);
        }
    }
}

