/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;

public abstract class AnyExpr {
    public static <T> T evalTree(Tree tree) {
        return (T)((AnyTree)tree).any;
    }

    public static AnyState newState(Scalar<?> scalar) {
        return new AnyState(scalar);
    }

    public static AnyMerger newMerger() {
        return new AnyMerger();
    }

    public static class AnyMerger
    extends FullMerger.Base<AnyTree>
    implements InsertMerger {
        private int count = 0;
        private Object any;

        @Override
        public void pushQ(AnyTree tree) {
            this.any = tree.any;
            ++this.count;
        }

        @Override
        public void pop() {
            if (--this.count == 0) {
                this.any = null;
            }
        }

        @Override
        public void clear() {
            this.any = null;
            this.count = 0;
        }

        @Override
        public AnyTree get() {
            return new AnyTree(this.any);
        }
    }

    public static class AnyState
    implements State {
        private final Scalar<?> scalar;
        private Object any;

        public AnyState(Scalar<?> scalar) {
            this.scalar = scalar;
            this.any = null;
        }

        @Override
        public void yield(Scope parent, Object message) {
            this.any = this.scalar.eval(parent, message);
        }

        @Override
        public Tree flip() {
            return new AnyTree(this.any);
        }
    }

    public static class AnyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Object any;

        public AnyTree(Object any) {
            this.any = any;
        }
    }
}

