/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;

public class ArgumentFlags
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LATE_BINDING = "late";
    public static final String OPTIONAL = "optional";
    public static final String VAR_ARGS = "varargs";
    public static final String ATT_BY = "#by";
    public static final String ATT_OVER = "#over";
    public static final String ATT_EVERY = "#every";
    private final boolean late;
    private final boolean optional;
    private final boolean varargs;
    private final Set<String> annotations;

    public ArgumentFlags(String ... flags) throws PipeException {
        this(Arrays.asList(flags));
    }

    public ArgumentFlags(Collection<String> flags) throws PipeException {
        LinkedHashSet<String> set = new LinkedHashSet<String>(flags);
        this.late = set.remove(LATE_BINDING);
        this.optional = set.remove(OPTIONAL);
        this.varargs = set.remove(VAR_ARGS);
        this.annotations = Collections.unmodifiableSet(this.extractAnnotations(set));
        PipeException.check(set.isEmpty(), "Unexpected argument flags: %s", set);
    }

    private Set<String> extractAnnotations(Collection<String> flags) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        Iterator<String> iterator = flags.iterator();
        while (iterator.hasNext()) {
            String flag = iterator.next();
            if (!flag.startsWith("#")) continue;
            annotations.add(flag);
            iterator.remove();
        }
        return annotations;
    }

    public boolean isLate() {
        return this.late;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public boolean isSuffix() {
        return Stream.of(ATT_BY, ATT_OVER, ATT_EVERY).anyMatch(this.annotations::contains);
    }

    public String toString(String name, AstNode defaultValue) {
        StringBuilder sb = new StringBuilder();
        if (this.annotations.contains(ATT_BY)) {
            sb.append("by ");
        }
        if (this.annotations.contains(ATT_OVER)) {
            sb.append("over ");
        }
        if (this.annotations.contains(ATT_EVERY)) {
            sb.append("every ");
        }
        if (this.annotations.size() > 0) {
            sb.append(Iterables.join("", this.annotations.stream().filter(x -> Stream.of(ATT_BY, ATT_OVER, ATT_EVERY).noneMatch(x::contains)).map(x -> "[" + x + "]").toArray()));
        }
        if (this.varargs) {
            sb.append("*");
        }
        if (this.late) {
            sb.append("&");
        }
        sb.append(Escapes.safeIdentifier(name));
        if (this.optional) {
            sb.append("=").append(defaultValue);
        }
        return sb.toString();
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }
}

