/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Scope;

public class ComparableAtom
implements Comparable<ComparableAtom>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private final Comparable[] comparables;

    public ComparableAtom(Object value, Comparable ... comparables) {
        this.value = value;
        this.comparables = comparables;
    }

    public static List<Object> extract(List<ComparableAtom> atoms) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ComparableAtom atom : atoms) {
            list.add(atom.value());
        }
        return list;
    }

    public static ComparableAtom create(Object value, Scope scope, Object raw, Evaluable<? extends Comparable> ... sorters) {
        Comparable[] comparables = new Comparable[sorters.length];
        for (int i = 0; i < sorters.length; ++i) {
            comparables[i] = sorters[i].eval(scope, raw);
        }
        return new ComparableAtom(value, comparables);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public int compareTo(ComparableAtom that) {
        if (this.comparables.length != that.comparables.length) {
            return this.comparables.length < that.comparables.length ? -1 : 1;
        }
        for (int i = 0; i < this.comparables.length; ++i) {
            int result;
            int n = this.comparables[i] == null ? (that.comparables[i] == null ? 0 : -1) : (result = that.comparables[i] == null ? 1 : this.comparables[i].compareTo(that.comparables[i]));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

