/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.AstFunction;
import net.intelie.pipes.Function;
import net.intelie.pipes.ListModule;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.types.Metadata;

public class FunctionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Metadata metadata;
    private final Function function;
    private final Map<String, AstNode> early;
    private final Map<String, AstNode> late;
    private final HashSet<String> keys;

    public FunctionContext(Metadata metadata) {
        this(metadata, null, null, null);
    }

    public FunctionContext(Metadata metadata, Function function, Map<String, AstNode> early, Map<String, AstNode> late) {
        this.metadata = metadata;
        this.function = function;
        this.early = early;
        this.late = late;
        this.keys = new HashSet();
        this.addKeys(early);
        this.addKeys(late);
    }

    public FunctionContext makeClosure(Function function, Map<String, AstNode> early, Map<String, AstNode> late) {
        LinkedHashMap<String, AstNode> newEarly = new LinkedHashMap<String, AstNode>();
        LinkedHashMap<String, AstNode> newLate = new LinkedHashMap<String, AstNode>();
        this.putAll(newEarly, this.early);
        this.putAll(newEarly, early);
        this.putAll(newLate, this.late);
        this.putAll(newLate, late);
        return new FunctionContext(this.metadata, function, newEarly, newLate);
    }

    private void putAll(Map<String, AstNode> newLate, Map<String, AstNode> late) {
        if (late != null) {
            newLate.putAll(late);
        }
    }

    public String getName() {
        if (this.function == null) {
            return null;
        }
        return this.function.name();
    }

    public String getDescription() {
        if (this.function == null) {
            return null;
        }
        return this.function.description();
    }

    public boolean sameFunctionAs(FunctionContext other) {
        return this.function != null && other.function != null && this.function.equals(other.function);
    }

    public boolean isFunction() {
        return this.function != null;
    }

    private void addKeys(Map<String, AstNode> arguments) {
        if (arguments != null) {
            this.keys.addAll(arguments.keySet());
        }
    }

    public AstNode resolveProperty(String name, boolean hasArgs, List<AstNode> args) throws PipeException {
        AstNode node = this.getInitialNode(name);
        if (node == null) {
            return null;
        }
        if (hasArgs) {
            ArrayList<AstNode> newArgs = new ArrayList<AstNode>();
            newArgs.add(node);
            newArgs.addAll(args);
            node = new CallNode(null, ".get", newArgs);
        }
        return node;
    }

    public Module makeModule() {
        ArrayList<Function> functions = new ArrayList<Function>();
        this.addArgs(functions, this.early);
        this.addArgs(functions, this.late);
        return new ListModule(functions);
    }

    private void addArgs(List<Function> functions, Map<String, AstNode> map) {
        if (map != null) {
            for (Map.Entry<String, AstNode> entry : map.entrySet()) {
                functions.add(new AstFunction.Constant("@@arg." + entry.getKey(), entry.getValue()));
            }
        }
    }

    public FunctionContext makeChild(Metadata metadata) {
        if (this.metadata.equals(metadata)) {
            return new FunctionContext(metadata, this.function, this.early, this.late);
        }
        return new FunctionContext(metadata, this.function, null, this.late);
    }

    private AstNode getInitialNode(String name) {
        AstNode node = null;
        if (this.early != null) {
            node = this.early.get(name);
        }
        if (node == null && this.late != null) {
            node = this.late.get(name);
        }
        return node;
    }
}

