/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.FunctionContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.util.Iterables;

public class FunctionContextList {
    private final FunctionContextList parent;
    private final FunctionContext context;

    public FunctionContextList(Metadata metadata) {
        this(null, new FunctionContext(metadata));
    }

    private FunctionContextList(FunctionContextList parent, FunctionContext context) {
        this.parent = parent;
        this.context = context;
    }

    public FunctionContext getContext() {
        return this.context;
    }

    public FunctionContextList makeChild(Metadata metadata) {
        return new FunctionContextList(this.parent, this.context.makeChild(metadata));
    }

    private boolean hasFunction(FunctionContext other, List<String> path) {
        if (this.context.sameFunctionAs(other) || this.parent != null && this.parent.hasFunction(other, path)) {
            if (this.context.isFunction()) {
                path.add(this.context.getDescription());
            }
            return true;
        }
        return false;
    }

    public FunctionContextList insideFunction(FunctionContext context) throws PipeException {
        ArrayList<String> path = new ArrayList<String>();
        if (this.hasFunction(context, path)) {
            path.add(context.getDescription());
            throw new PipeException("Recursive function expansion not allowed: %s", Iterables.join("->", path));
        }
        return new FunctionContextList(this, context);
    }
}

