/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Iterator;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.HasType;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Preconditions;

public interface GroupBy
extends Evaluable<Row>,
HasType<Row>,
Serializable {
    public static final GroupBy NONE = new NoneGroupBy();

    public int size();

    public boolean isEmpty();

    public GroupBy ensureNoExpiry() throws PipeException;

    public GroupBy ensureExpiry() throws PipeException;

    public void validate(ValidationContext var1) throws PipeException;

    public ClauseInfo info();

    public <T> State<T> newState(Init<T> var1);

    public void evalUnsafe(Scope var1, Object var2, UnsafeRow var3);

    public void evalUnsafe(Scope var1, Object var2, UnsafeRow var3, int var4);

    public static class NoneGroupBy
    implements GroupBy {
        private static final long serialVersionUID = 1L;
        private static final ArrayRow EMPTY_ROW = new ArrayRow(new Object[0]);
        private static final UnsafeRow EMPTY_UNSAFE_ROW = new UnsafeRow(0);

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public GroupBy ensureNoExpiry() throws PipeException {
            return this;
        }

        @Override
        public GroupBy ensureExpiry() throws PipeException {
            return this;
        }

        @Override
        public void validate(ValidationContext context) throws PipeException {
        }

        @Override
        public void evalUnsafe(Scope parent, Object obj, UnsafeRow row) {
        }

        @Override
        public void evalUnsafe(Scope parent, Object obj, UnsafeRow row, int index) {
        }

        @Override
        public ClauseInfo info() {
            return new ClauseInfo(new FieldInfo[0]);
        }

        @Override
        public Row eval(Scope parent, Object obj) {
            return EMPTY_ROW;
        }

        @Override
        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            return visitor;
        }

        @Override
        public Type<Row> type() {
            return new RowType(new RowFields(new FieldInfo[0]));
        }

        public String toString() {
            return "";
        }

        @Override
        public <T> State<T> newState(final Init<T> initializer) {
            return new State<T>(){
                private static final long serialVersionUID = 1L;
                private T state;
                {
                    this.state = initializer.init(EMPTY_UNSAFE_ROW);
                }

                @Override
                public void offerTimestamp(long timestamp) {
                }

                @Override
                public T get(Scope parent, Object obj) {
                    return this.state;
                }

                @Override
                public T emptyState() {
                    return this.state;
                }

                @Override
                public Iterator<T> iterator() {
                    return new Iterator<T>(){
                        private boolean consumed = false;

                        @Override
                        public boolean hasNext() {
                            return !this.consumed;
                        }

                        @Override
                        public T next() {
                            Preconditions.checkState(!this.consumed);
                            this.consumed = true;
                            return state;
                        }

                        @Override
                        public void remove() {
                            Preconditions.checkState(this.consumed);
                            state = initializer.init(EMPTY_UNSAFE_ROW);
                        }
                    };
                }
            };
        }
    }

    public static interface State<T>
    extends Iterable<T>,
    Serializable {
        public T get(Scope var1, Object var2);

        public void offerTimestamp(long var1);

        public T emptyState();
    }

    public static interface Init<T> {
        public T init(UnsafeRow var1);
    }
}

