/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Tree;

public interface InsertMerger {
    public void push(Tree var1);

    public void clear();

    public Tree get();

    public static void pushMany(InsertMerger[] mergers, Tree[] trees) {
        for (int i = 0; i < Math.min(mergers.length, trees.length); ++i) {
            mergers[i].push(trees[i]);
        }
    }

    public static void clearMany(InsertMerger[] mergers) {
        for (InsertMerger merger : mergers) {
            merger.clear();
        }
    }

    public static Tree[] getMany(InsertMerger[] mergers) {
        Tree[] trees = new Tree[mergers.length];
        for (int i = 0; i < mergers.length; ++i) {
            trees[i] = mergers[i].get();
        }
        return trees;
    }

    public static void pushMany(FullMerger[] mergers, Tree[] trees) {
        for (int i = 0; i < Math.min(mergers.length, trees.length); ++i) {
            mergers[i].push(trees[i]);
        }
    }

    public static void clearMany(FullMerger[] mergers) {
        for (FullMerger merger : mergers) {
            merger.clear();
        }
    }

    public static Tree[] getMany(FullMerger[] mergers) {
        Tree[] trees = new Tree[mergers.length];
        for (int i = 0; i < mergers.length; ++i) {
            trees[i] = mergers[i].get();
        }
        return trees;
    }

    public static abstract class Base<Q extends Tree>
    implements InsertMerger {
        @Override
        public void push(Tree tree) {
            this.pushQ(tree);
        }

        public abstract void pushQ(Q var1);

        public abstract Q get();
    }
}

