/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.intelie.pipes.Function;
import net.intelie.pipes.Module;
import net.intelie.pipes.util.Iterables;

public class ListModule
implements Module {
    private static final long serialVersionUID = 1L;
    private final List<Function> functions;
    private final String repr;

    public ListModule(Function ... functions) {
        this(Arrays.asList(functions));
    }

    public ListModule(List<Function> functions) {
        this.functions = new ArrayList<Function>(functions);
        this.repr = this.makeRepr(functions);
    }

    private String makeRepr(List<Function> functions) {
        ArrayList<String> repr = new ArrayList<String>();
        for (Function function : functions) {
            repr.add(function.description());
        }
        return "functions: " + Iterables.join(", ", repr);
    }

    public String toString() {
        return this.repr;
    }

    @Override
    public Iterable<Function> functions() {
        return Collections.unmodifiableList(this.functions);
    }
}

