/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.AstFunction;
import net.intelie.pipes.Function;
import net.intelie.pipes.Module;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.RawNode;

public class MacroModule
implements Module {
    private static final long serialVersionUID = 1L;
    private final List<Function> functions;

    public MacroModule(Object ... args) {
        this((AstNode[])Arrays.stream(args).map(RawNode::new).toArray(AstNode[]::new));
    }

    private MacroModule(AstNode[] nodes) {
        this.functions = MacroModule.makeFunctions(nodes);
    }

    public static List<Function> makeFunctions(final AstNode[] args) {
        ArrayList<Function> functions = new ArrayList<Function>();
        int i = 0;
        while (i < args.length) {
            final int ii = i++;
            functions.add(new AstFunction("@@" + ii){

                @Override
                public AstNode getNode(ArgQueue queue) {
                    return args[ii];
                }
            });
        }
        return functions;
    }

    public static MacroModule fromAstNodes(AstNode ... args) {
        return new MacroModule(args);
    }

    public static MacroModule fromCompiled(Object ... args) {
        return new MacroModule(args);
    }

    @Override
    public Iterable<Function> functions() {
        return this.functions;
    }

    public String toString() {
        return "macro module with " + this.functions.size() + " macros";
    }
}

