/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.DefaultMapAdapter;
import net.intelie.pipes.MapAdapter;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PipePropertySource;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.PropertyReplacer;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.GetUtils;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Levenshtein;

public class MapPropertySource
implements PropertySource {
    public static final String TIMESTAMP = "timestamp";
    private static final long serialVersionUID = 1L;
    private final List<PropertyGroup> defaultProperties;
    private final String timestampKey;
    private final Map<String, Type> types;
    private final boolean strict;
    private final MapAdapter adapter;
    private final Metadata metadata;

    public MapPropertySource() {
        this(TIMESTAMP, Collections.emptyList(), Collections.emptyMap(), false, null, Metadata.RAW);
    }

    private MapPropertySource(String timestampKey, List<PropertyGroup> defaultProperties, Map<String, Type> types, boolean strict, MapAdapter adapter, Metadata metadata) {
        this.timestampKey = timestampKey;
        this.adapter = adapter != null ? adapter : new DefaultMapAdapter();
        this.metadata = metadata;
        this.defaultProperties = defaultProperties;
        this.types = types;
        this.strict = strict;
    }

    private List<PropertyGroup> resolve(List<String> defaultProperties) throws PipeException {
        ArrayList<PropertyGroup> props = new ArrayList<PropertyGroup>(defaultProperties.size());
        for (String name : defaultProperties) {
            props.add(new PropertyGroup(this.property(name)));
        }
        return props;
    }

    public MapPropertySource asStrict() {
        return this.asStrict(true);
    }

    public MapPropertySource asStrict(boolean strict) {
        return new MapPropertySource(this.timestampKey, this.defaultProperties, this.types, strict, this.adapter, this.metadata);
    }

    public MapPropertySource safe() {
        return this.safe(true);
    }

    public MapPropertySource safe(boolean safe) {
        return new MapPropertySource(this.timestampKey, this.defaultProperties, this.types, this.strict, this.adapter, this.metadata.withSafe(safe));
    }

    public MapPropertySource withTypes(Map<String, Type> types) {
        return new MapPropertySource(this.timestampKey, this.defaultProperties, types, this.strict, this.adapter, this.metadata);
    }

    public MapPropertySource withDefaultProperties(String ... filterProperties) throws PipeException {
        return this.withDefaultProperties(Arrays.asList(filterProperties));
    }

    public MapPropertySource withDefaultProperties(List<String> filterProperties) throws PipeException {
        return new MapPropertySource(this.timestampKey, this.resolve(filterProperties), this.types, this.strict, this.adapter, this.metadata);
    }

    public MapPropertySource withTimestamp(String timestampKey) {
        return new MapPropertySource(timestampKey, this.defaultProperties, this.types, this.strict, this.adapter, this.metadata);
    }

    public MapPropertySource withAdapter(MapAdapter adapter) {
        return new MapPropertySource(this.timestampKey, this.defaultProperties, this.types, this.strict, adapter, this.metadata);
    }

    @Override
    public Property<Double> timestamp() throws PipeException {
        return this.makeProp(this.timestampKey, Type.NUMBER);
    }

    @Override
    public Property property() throws PipeException {
        return new MapProperty(this.metadata.type(), null);
    }

    @Override
    public PropertySource newSource(Metadata metadata) {
        return metadata.hasRowFields() ? new PipePropertySource(metadata) : new MapPropertySource(this.timestampKey, this.defaultProperties, this.types, this.strict, this.adapter, metadata);
    }

    @Override
    public Property property(String name) throws PipeException {
        Type type = this.types.get(name);
        if (type == null && (this.strict || this.doesNotAcceptProperty())) {
            throw Levenshtein.makeExc(name, this.types.keySet(), "Cannot resolve property '%s'.%s");
        }
        return this.makeProp(name, type);
    }

    private boolean doesNotAcceptProperty() {
        return !Type.OBJECT.equals(this.metadata.type()) && !this.metadata.type().isAssignableTo(Type.MAP);
    }

    private Property makeProp(String name, Type type) throws PipeException {
        return new MapProperty(type, name);
    }

    @Override
    public List<PropertyGroup> defaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public PropertyReplacer makeReplacer() {
        return this.adapter;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    public class MapProperty
    implements Property {
        private static final long serialVersionUID = 3847552900381849629L;
        private final Type originalType;
        private final Type hint;
        private final Type type;
        private final String identifier;
        private final boolean single;
        private final Scalar[] nth;
        private final boolean reallySingle;
        private final boolean requiresObjectFix;

        public MapProperty(Type type, String identifier) throws PipeException {
            this(type, null, identifier, true, new Scalar[0]);
        }

        public MapProperty(Type originalType, Type hint, String identifier, boolean single, Scalar ... nth) throws PipeException {
            this.originalType = originalType;
            this.hint = hint;
            this.single = single;
            this.reallySingle = single && nth.length == 0;
            Type type = this.makeType(originalType, hint, identifier, this.reallySingle, nth);
            this.type = type != null ? type : Type.STRING;
            this.requiresObjectFix = type == null;
            this.identifier = identifier;
            this.nth = nth;
        }

        @Override
        public boolean requiresObjectFix() {
            return this.requiresObjectFix;
        }

        private Type makeType(Type originalType, Type hint, String identifier, boolean reallySingle, Scalar[] nth) throws PipeException {
            Type answer;
            if (hint != null) {
                return hint;
            }
            if (originalType == null) {
                originalType = MapPropertySource.this.adapter.type(identifier, reallySingle);
            }
            if ((answer = GetUtils.inferType(originalType, nth)) != null) {
                return answer;
            }
            return null;
        }

        @Override
        public Object eval(Scope parent, Object obj) {
            if (this.identifier == null) {
                return this.type.cast(this.resolveIndexes(parent, obj, obj));
            }
            return this.type.cast(this.resolveValue(parent, obj));
        }

        @Override
        public boolean sameProperty(Property other) {
            if (!(other instanceof MapProperty)) {
                return false;
            }
            MapProperty that = (MapProperty)other;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.type, that.type) && this.sameScalars(this.nth, that.nth);
        }

        private boolean sameScalars(Scalar[] thisNth, Scalar[] thatNth) {
            if (thisNth.length != thatNth.length) {
                return false;
            }
            for (int i = 0; i < thisNth.length; ++i) {
                if (Level.CONSTANT.accepts(thatNth[i]) && Level.CONSTANT.accepts(thisNth[i]) && Objects.equals(Level.asScalar(thisNth[i]).eval(null, null), Level.asScalar(thatNth[i]).eval(null, null))) continue;
                return false;
            }
            return true;
        }

        private Object resolveValue(Scope parent, Object obj) {
            Object value = this.identifier == null ? obj : MapPropertySource.this.adapter.get(obj, this.identifier, this.reallySingle);
            return this.resolveIndexes(parent, obj, value);
        }

        private Object resolveIndexes(Scope parent, Object obj, Object value) {
            if (this.nth.length == 0) {
                return value;
            }
            for (Scalar scalar : this.nth) {
                value = GetUtils.get(value, scalar.eval(parent, obj));
            }
            return value;
        }

        @Override
        public Type<Object> type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.identifier == null ? "_" : this.identifier;
        }

        @Override
        public Iterable<Scalar> args() {
            return Arrays.asList(this.nth);
        }

        public Property indexed(Scalar ... args) throws PipeException {
            return new MapProperty(this.originalType, this.hint, this.identifier, false, args);
        }

        @Override
        public Property hint(Type type) throws PipeException {
            return new MapProperty(this.originalType, type, this.identifier, this.single, this.nth);
        }

        @Override
        public void evalRaw(Scope parent, Object obj, ObjectSink sink) {
            if (this.identifier == null) {
                sink.onSingle(obj);
                return;
            }
            Object o = MapPropertySource.this.adapter.get(obj, this.identifier, false);
            if (o instanceof Iterable) {
                for (Object child : (Iterable)o) {
                    sink.onSingle(child);
                }
            } else {
                sink.onSingle(o);
            }
        }

        @Override
        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            for (Scalar scalar : this.nth) {
                scalar.visit(parent, visitor);
            }
            return this.identifier == null ? visitor.anyProperty() : visitor.property(this);
        }

        public String toString() {
            return "map:" + this.name() + "[" + Iterables.join(", ", Arrays.asList(this.nth)) + "]@" + this.type;
        }
    }
}

