/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.lang.reflect.InvocationTargetException;
import net.intelie.pipes.ast.SourceLocation;

public class PipeException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static boolean DEBUG = false;
    private final Level level;
    private final SourceLocation location;

    public PipeException(Object message) {
        this(null, Level.SEMANTIC, String.valueOf(message));
    }

    public PipeException(String message, Object ... objs) {
        this(null, Level.SEMANTIC, PipeException.format(message, objs));
    }

    public PipeException(SourceLocation location, Level level, String message) {
        super((location != null ? "At (" + location + "): " : "") + message, null, DEBUG, DEBUG);
        this.level = level;
        this.location = location;
    }

    public static void check(boolean condition, Object errorMessage) throws PipeException {
        if (!condition) {
            throw new PipeException((Object)String.valueOf(errorMessage));
        }
    }

    public static void check(boolean condition, String errorMessage, Object ... objs) throws PipeException {
        if (!condition) {
            throw new PipeException((Object)PipeException.format(errorMessage, objs));
        }
    }

    public static void checkNotNull(Object value, Object errorMessage) throws PipeException {
        if (value == null) {
            throw new PipeException((Object)String.valueOf(errorMessage));
        }
    }

    public static void checkNotNull(Object value, String errorMessage, Object ... objs) throws PipeException {
        if (value == null) {
            throw new PipeException((Object)PipeException.format(errorMessage, objs));
        }
    }

    public static PipeException handle(Throwable e) {
        if (e instanceof PipeException) {
            return (PipeException)e;
        }
        if (e instanceof InvocationTargetException) {
            return PipeException.handle(e.getCause());
        }
        return new PipeException("(%s) %s", e.getClass().getSimpleName(), e.getMessage());
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = PipeException.nextTemplateStart(template, templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static int nextTemplateStart(String template, int templateStart) {
        int answer;
        do {
            if ((answer = template.indexOf("%", templateStart)) == -1 || answer + 1 >= template.length()) {
                return -1;
            }
            ++templateStart;
        } while (!Character.isAlphabetic(template.charAt(answer + 1)));
        return answer;
    }

    public PipeException maybeAddSource(SourceLocation location) {
        if (this.location != null) {
            return this;
        }
        return new PipeException(location, this.level, this.getMessage());
    }

    public Level level() {
        return this.level;
    }

    public SourceLocation location() {
        return this.location;
    }

    public PipeException maybeRemoveSource() {
        if (this.location == null) {
            return this;
        }
        return new PipeException(null, this.level, this.getMessage());
    }

    public static enum Level {
        SYNTACTIC,
        SEMANTIC;

    }
}

