/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.PropertyReplacer;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.GetUtils;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Levenshtein;

public class PipePropertySource
implements PropertySource {
    private static final long serialVersionUID = 1L;
    private final RowFields fields;
    private final int offset;
    private final Metadata metadata;

    public PipePropertySource(Metadata metadata) {
        this.metadata = metadata;
        this.fields = metadata.getRowFields();
        this.offset = this.fields.timestamp().size() + this.fields.group().size();
    }

    @Override
    public Property<Double> timestamp() throws PipeException {
        if (this.fields.indexOf("timestamp") < 0) {
            return new PipeProperty((Type)Type.NUMBER, "timestamp", -1, new Scalar[0]);
        }
        return this.property(Type.NUMBER, "timestamp");
    }

    @Override
    public Property property() throws PipeException {
        return new PipeProperty(this.defineTypeFor(this.offset), this.fields.name(this.offset), this.offset, new Scalar[0]);
    }

    @Override
    public Property property(String name) throws PipeException {
        return this.property(null, name);
    }

    Property property(Type declared, String name) throws PipeException {
        int index = this.fields.indexOf(name);
        if (index < 0) {
            throw Levenshtein.makeExc(name, this.fields.names(), "Cannot resolve property '%s'.%s");
        }
        return new PipeProperty(declared == null ? this.defineTypeFor(index) : declared, name, index, new Scalar[0]);
    }

    @Override
    public List<PropertyGroup> defaultProperties() {
        return Collections.emptyList();
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public PropertyReplacer makeReplacer() {
        return new PipePropertyReplacer();
    }

    @Override
    public PropertySource newSource(Metadata metadata) {
        throw new UnsupportedOperationException("Can't use newSource on a PipePropertySource");
    }

    private Type defineTypeFor(int index) throws PipeException {
        return this.fields.type(index);
    }

    public static class PipePropertyReplacer
    implements PropertyReplacer {
        private static final long serialVersionUID = 1L;

        @Override
        public Object replaceValues(Object obj, RowFields fields, Row row) {
            if (!(obj instanceof Row)) {
                return obj;
            }
            return ArrayRow.concat((Row)obj, row);
        }
    }

    public static class PipeProperty
    implements Property {
        private final Type originalType;
        private final Type type;
        private final String identifier;
        private final int index;
        private final Scalar[] args;

        public PipeProperty(Type type, String identifier, int index, Scalar ... args) throws PipeException {
            this(type, type, identifier, index, args);
        }

        public PipeProperty(Type originalType, Type type, String identifier, int index, Scalar ... args) throws PipeException {
            this.originalType = originalType;
            this.type = type != null ? type : Type.OBJECT;
            this.identifier = identifier;
            this.index = index;
            this.args = args;
        }

        @Override
        public Object eval(Scope parent, Object obj) {
            if (this.index == -1) {
                return null;
            }
            Row row = this.castRow(obj);
            if (row == null) {
                return null;
            }
            Object value = row.get(this.index);
            for (Scalar arg : this.args) {
                value = GetUtils.get(value, arg.eval(parent, obj));
            }
            return this.type.cast(value);
        }

        @Override
        public boolean sameProperty(Property other) {
            if (!(other instanceof PipeProperty)) {
                return false;
            }
            PipeProperty that = (PipeProperty)other;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.index, that.index) && Objects.equals(this.type, that.type) && this.sameScalars(this.args, that.args);
        }

        @Override
        public boolean requiresObjectFix() {
            return false;
        }

        private boolean sameScalars(Scalar[] thisNth, Scalar[] thatNth) {
            if (thisNth.length != thatNth.length) {
                return false;
            }
            for (int i = 0; i < thisNth.length; ++i) {
                if (Level.CONSTANT.accepts(thatNth[i]) && Level.CONSTANT.accepts(thisNth[i]) && Objects.equals(Level.asScalar(thisNth[i]).eval(null, null), Level.asScalar(thatNth[i]).eval(null, null))) continue;
                return false;
            }
            return true;
        }

        private Row castRow(Object obj) {
            if (!(obj instanceof Row)) {
                return null;
            }
            Row row = (Row)obj;
            if (this.index >= row.size()) {
                return null;
            }
            return row;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.identifier;
        }

        @Override
        public Iterable<Scalar> args() {
            return Arrays.asList(this.args);
        }

        public Property indexed(Scalar ... args) throws PipeException {
            return new PipeProperty(this.originalType, GetUtils.inferType(this.originalType, args), this.identifier, this.index, args);
        }

        @Override
        public Property hint(Type type) throws PipeException {
            return new PipeProperty(type, this.identifier, this.index, this.args);
        }

        @Override
        public void evalRaw(Scope parent, Object obj, ObjectSink sink) {
            if (this.index == -1) {
                return;
            }
            Row row = this.castRow(obj);
            if (row == null) {
                return;
            }
            Object o = row.get(this.index);
            for (Scalar scalar : this.args) {
                o = GetUtils.get(o, scalar.eval(parent, obj));
            }
            sink.onSingle(o);
        }

        @Override
        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            for (Scalar scalar : this.args) {
                scalar.visit(parent, visitor);
            }
            return visitor.property(this);
        }

        public String toString() {
            return "pipe:" + this.identifier + "[" + Iterables.join(", ", Arrays.asList(this.args)) + "]@" + this.type;
        }
    }
}

