/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Tree;

public interface SimpleMerger {
    public void add(Tree var1);

    public void remove(Tree var1);

    public void clear();

    public Tree get();

    public static FullMerger makeFullMerger(final SimpleMerger merger) {
        return new FullMerger.Queued<Tree>(){

            @Override
            public void pushQ(Tree tree) {
                merger.add(tree);
            }

            @Override
            public void popQ(Tree tree) {
                merger.remove(tree);
            }

            @Override
            public void clearQ() {
                merger.clear();
            }

            @Override
            public Tree get() {
                return merger.get();
            }
        };
    }

    public static InsertMerger makeInsertMerger(final SimpleMerger merger) {
        return new InsertMerger.Base<Tree>(){

            @Override
            public void pushQ(Tree tree) {
                merger.add(tree);
            }

            @Override
            public Tree get() {
                return merger.get();
            }

            @Override
            public void clear() {
                merger.clear();
            }
        };
    }

    public static abstract class Base<Q extends Tree>
    implements SimpleMerger {
        @Override
        public void add(Tree tree) {
            this.addQ(tree);
        }

        @Override
        public void remove(Tree tree) {
            this.removeQ(tree);
        }

        public abstract void addQ(Q var1);

        public abstract void removeQ(Q var1);

        public abstract Q get();
    }
}

