/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Arrays;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;

public class ValidationContext {
    private final boolean hasWindow;

    public ValidationContext(boolean hasWindow) {
        this.hasWindow = hasWindow;
    }

    public ValidationContext maybeDefer(Object obj) throws PipeException {
        if (obj instanceof Expression) {
            return this.defer((Expression)obj);
        }
        return this;
    }

    public ValidationContext defer(Expression ... expressions) throws PipeException {
        return this.defer(Arrays.asList(expressions));
    }

    public ValidationContext defer(Iterable<? extends Expression> iterable) throws PipeException {
        for (Expression expression : iterable) {
            if (expression == null) continue;
            expression.validate(this);
        }
        return this;
    }

    public Instance validateAs(Expression instance) {
        return new Instance(instance);
    }

    public class Instance {
        private final Expression instance;

        public Instance(Expression instance) {
            this.instance = instance;
        }

        public Instance ensureNoWindow() throws PipeException {
            if (ValidationContext.this.hasWindow) {
                throw new PipeException("Expression '%s' can't be used inside a windowed aggregation.", this.instance);
            }
            return this;
        }
    }
}

