/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern pattern = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(-SNAPSHOT)?$");
    private final String value;
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean release;

    public Version(String value, int major, int minor, int patch, boolean release) {
        new VersionHolder();
        this.value = value;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.release = release;
    }

    public static Version fromString(String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            return null;
        }
        int major = Version.parseInt(matcher, 1);
        int minor = Version.parseInt(matcher, 2);
        int patch = Version.parseInt(matcher, 3);
        boolean release = matcher.matches() && matcher.group(4) == null;
        return new Version(version, major, minor, patch, release);
    }

    private static int parseInt(Matcher matcher, int group) {
        if (!matcher.matches()) {
            return 0;
        }
        String grp = matcher.group(group);
        if (grp == null) {
            return 0;
        }
        return Integer.parseInt(grp);
    }

    public static Version current() {
        return VersionHolder.instance;
    }

    public static Version load(String path) {
        return Version.getVersion(path);
    }

    /*
     * Exception decompiling
     */
    private static Version getVersion(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String value() {
        return this.value;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public boolean release() {
        return this.release;
    }

    public String simple() {
        return String.format((Locale)null, "%d.%d", this.major, this.minor);
    }

    public String toString() {
        return this.complete();
    }

    public String complete() {
        return String.format((Locale)null, "%d.%d.%d%s", this.major, this.minor, this.patch, this.release ? "" : "-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return Objects.equals(this.major, that.major) && Objects.equals(this.minor, that.minor) && Objects.equals(this.patch, that.patch) && Objects.equals(this.release, that.release);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.release);
    }

    @Override
    public int compareTo(Version that) {
        int v = Integer.compare(this.major, that.major);
        if (v != 0) {
            return v;
        }
        v = Integer.compare(this.minor, that.minor);
        if (v != 0) {
            return v;
        }
        v = Integer.compare(this.patch, that.patch);
        if (v != 0) {
            return v;
        }
        v = Boolean.compare(this.release, that.release);
        if (v != 0) {
            return v;
        }
        return 0;
    }

    private static class VersionHolder {
        public static final Version instance = Version.load("/PIPES_VERSION");

        private VersionHolder() {
        }
    }
}

