/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.SourceAwareNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.util.Iterables;

public class PropertyNode
implements SourceAwareNode {
    private static final long serialVersionUID = 1L;
    private final SourceLocation location;
    private final AstNode target;
    private final String name;
    private final boolean hasArgs;
    private final List<AstNode> args;
    private final int _hash;

    public PropertyNode(SourceLocation location, AstNode target, String name) {
        this(location, target, name, false, new AstNode[0]);
    }

    public PropertyNode(SourceLocation location, AstNode target, String name, boolean hasArgs, AstNode ... args) {
        this(location, target, name, hasArgs, Arrays.asList(args));
    }

    public PropertyNode(SourceLocation location, AstNode target, String name, boolean hasArgs, List<? extends AstNode> args) {
        this.location = location;
        this.target = target;
        this.name = name;
        this.hasArgs = hasArgs;
        this.args = new ArrayList<AstNode>(args);
        this._hash = Objects.hash(this.target, this.name, this.hasArgs, this.args);
    }

    public static PropertyNode defaultProperty(SourceLocation location) {
        return new PropertyNode(location, null, null, false, Collections.emptyList());
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    public AstNode getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasArgs() {
        return this.hasArgs;
    }

    public List<AstNode> getArgs() {
        return this.args;
    }

    public String toString() {
        String value = this.toStringPropOnly();
        if (this.target != null) {
            value = this.target + "->" + value;
        }
        return value;
    }

    public String toStringPropOnly() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name != null ? this.name : "_");
        if (this.hasArgs) {
            builder.append("[");
            builder.append(Iterables.join(", ", this.args));
            builder.append("]");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyNode that = (PropertyNode)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.name, that.name) && Objects.equals(this.hasArgs, that.hasArgs) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return this._hash;
    }
}

