/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.cron.CronParsingHelper;
import net.intelie.pipes.cron.Field;
import net.intelie.pipes.cron.FieldType;
import net.intelie.pipes.cron.ValueField;

public class Cron
implements Field {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RETRIES = 100;
    private final List<Field> fields;
    private final List<Field> evalOrder;

    public Cron(String expression) {
        this(CronParsingHelper.parse(expression));
    }

    public Cron(Field seconds, Field minutes, Field hours, Field days, Field months, Field daysOfWeek) {
        this(Arrays.asList(seconds, minutes, hours, days, months, daysOfWeek));
    }

    private Cron(List<Field> fields) {
        this.fields = fields;
        this.evalOrder = new ArrayList<Field>(fields);
        Collections.reverse(this.evalOrder);
        this.evalOrder.add(new ValueField(FieldType.NANOS, 0));
    }

    public <T extends Temporal & Comparable<? super T>> T next(T date) {
        if (date == null) {
            return null;
        }
        return this.nextOrSame(ChronoUnit.NANOS.addTo(date, 1L));
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T date) {
        if (date == null) {
            return null;
        }
        for (int i = 0; i < 100; ++i) {
            T result = this.nextSingle(date);
            if (result == null || result.equals(date)) {
                return result;
            }
            date = result;
        }
        return null;
    }

    private <T extends Temporal & Comparable<? super T>> T nextSingle(T date) {
        for (Field field : this.evalOrder) {
            date = field.nextOrSame(date);
        }
        return date;
    }

    public <T extends Temporal & Comparable<? super T>> T prev(T date) {
        if (date == null) {
            return null;
        }
        return this.prevOrSame(ChronoUnit.NANOS.addTo(date, -1L));
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T prevOrSame(T date) {
        if (date == null) {
            return null;
        }
        for (int i = 0; i < 100; ++i) {
            T result = this.prevSingle(date);
            if (result == null || result.equals(date)) {
                return result;
            }
            date = result;
        }
        return null;
    }

    private <T extends Temporal & Comparable<? super T>> T prevSingle(T date) {
        for (Field field : this.evalOrder) {
            date = field.prevOrSame(date);
        }
        return date;
    }

    @Override
    public boolean matches(Temporal date) {
        if (date == null) {
            return false;
        }
        for (Field field : this.evalOrder) {
            if (field.matches(date)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.fields.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cron that = (Cron)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }
}

