/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.intelie.pipes.cron.CronException;
import net.intelie.pipes.cron.Field;
import net.intelie.pipes.cron.FieldList;
import net.intelie.pipes.cron.FieldType;
import net.intelie.pipes.cron.RangeField;
import net.intelie.pipes.cron.StarField;
import net.intelie.pipes.cron.ValueField;

class CronParsingHelper {
    private static final Map<String, Integer> MONTHS = CronParsingHelper.aliases("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
    private static final Map<String, Integer> DAYS_OF_WEEK = CronParsingHelper.aliases("MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN");

    CronParsingHelper() {
    }

    private static Map<String, Integer> aliases(String ... values) {
        return Collections.unmodifiableMap(IntStream.range(0, values.length).boxed().collect(Collectors.toMap(x -> values[x], x -> x + 1)));
    }

    public static List<Field> parse(String expr) {
        expr = CronParsingHelper.alias(expr, "@yearly", "0 0 1 1 *");
        expr = CronParsingHelper.alias(expr, "@annually", "0 0 1 1 *");
        expr = CronParsingHelper.alias(expr, "@monthly", "0 0 1 * *");
        expr = CronParsingHelper.alias(expr, "@weekly", "0 0 * * 0");
        expr = CronParsingHelper.alias(expr, "@daily", "0 0 * * *");
        expr = CronParsingHelper.alias(expr, "@midnight", "0 0 * * *");
        String[] fields = (expr = CronParsingHelper.alias(expr, "@hourly", "0 * * * *")).split("\\s+");
        CronException.check(fields.length == 5 || fields.length == 6, "Expression '%s' must define 5 or 6 fields. It has: %d.", expr, fields.length);
        int offset = fields.length - 5;
        return Arrays.asList(offset == 1 ? CronParsingHelper.parseOther(FieldType.SECOND, fields[0]) : new ValueField(FieldType.SECOND, 0), CronParsingHelper.parseOther(FieldType.MINUTE, fields[offset]), CronParsingHelper.parseOther(FieldType.HOUR, fields[offset + 1]), CronParsingHelper.parseOther(FieldType.DAY, fields[offset + 2]), CronParsingHelper.parseMonth(fields[offset + 3]), CronParsingHelper.parseDayOfWeek(fields[offset + 4]));
    }

    private static String alias(String expression, String from, String to) {
        if (from.equalsIgnoreCase(expression)) {
            return to;
        }
        return expression;
    }

    public static Field parseDayOfWeek(String field) {
        return CronParsingHelper.parseField(FieldType.DAY_OF_WEEK, field, DAYS_OF_WEEK);
    }

    public static Field parseMonth(String field) {
        return CronParsingHelper.parseField(FieldType.MONTH, field, MONTHS);
    }

    public static Field parseOther(FieldType type, String expr) {
        return CronParsingHelper.parseField(type, expr, Collections.emptyMap());
    }

    private static Field parseField(FieldType type, String expr, Map<String, Integer> aliases) {
        try {
            ArrayList<Field> list = new ArrayList<Field>();
            for (String field : expr.split(",")) {
                list.add(CronParsingHelper.parseSingle(type, field, aliases));
            }
            if (list.size() == 1) {
                return (Field)list.get(0);
            }
            return new FieldList(list);
        }
        catch (CronException e) {
            throw new CronException("%s (%s = '%s')", e.getMessage(), type.toString().toLowerCase(Locale.ROOT), expr);
        }
    }

    private static Field parseSingle(FieldType type, String expr, Map<String, Integer> aliases) {
        String step;
        String[] slashed = expr.split("/", 2);
        String[] dashed = slashed[0].split("-", 2);
        String start = dashed[0];
        String end = dashed.length == 2 ? dashed[1] : null;
        String string = step = slashed.length == 2 ? slashed[1] : null;
        if (step != null || end != null) {
            Integer startValue = CronParsingHelper.parseValue(type, start, aliases);
            Integer endValue = CronParsingHelper.parseValue(type, end, aliases);
            Integer stepValue = CronParsingHelper.parseValue(type, step, null);
            if (startValue != null && endValue != null && startValue > endValue) {
                return new FieldList(new RangeField(type, null, endValue, stepValue), new RangeField(type, startValue, null, stepValue));
            }
            return new RangeField(type, startValue, endValue, stepValue);
        }
        Integer value = CronParsingHelper.parseValue(type, start, aliases);
        if (value == null) {
            return new StarField();
        }
        return new ValueField(type, value);
    }

    private static Integer parseValue(FieldType type, String expr, Map<String, Integer> aliases) {
        Integer value;
        if (expr == null) {
            return null;
        }
        if ("*".equals(expr) || "".equals(expr)) {
            return null;
        }
        if (aliases != null && (value = aliases.get(expr.toUpperCase(Locale.ROOT))) != null) {
            return value;
        }
        try {
            int parsed = Integer.parseInt(expr);
            if (type == FieldType.DAY_OF_WEEK && parsed == 0) {
                return DayOfWeek.SUNDAY.getValue();
            }
            return parsed;
        }
        catch (Exception e) {
            throw new CronException((Object)String.format((Locale)null, "Invalid expression: '%s'", expr));
        }
    }
}

