/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.cron.Field;

public class FieldList
implements Field {
    private static final long serialVersionUID = 1L;
    private final List<Field> fields;

    public FieldList(Field ... fields) {
        this(Arrays.asList(fields));
    }

    public FieldList(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T date) {
        Object next = null;
        for (Field field : this.fields) {
            T candidate = field.nextOrSame(date);
            if (next != null && (candidate == null || ((Comparable<Object>)candidate).compareTo(next) >= 0)) continue;
            next = candidate;
        }
        return next;
    }

    @Override
    public boolean matches(Temporal date) {
        for (Field field : this.fields) {
            if (!field.matches(date)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T prevOrSame(T date) {
        Object next = null;
        for (Field field : this.fields) {
            T candidate = field.prevOrSame(date);
            if (next != null && (candidate == null || ((Comparable<Object>)candidate).compareTo(next) <= 0)) continue;
            next = candidate;
        }
        return next;
    }

    public String toString() {
        return this.fields.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldList that = (FieldList)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }
}

