/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.ValueRange;

public enum FieldType {
    NANOS(ChronoField.NANO_OF_SECOND, new ChronoField[0]),
    SECOND(ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
    MINUTE(ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
    HOUR(ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
    DAY(ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
    MONTH(ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
    DAY_OF_WEEK(ChronoField.DAY_OF_WEEK, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND);

    private final ChronoField field;
    private final ChronoField[] clear;

    private FieldType(ChronoField field, ChronoField ... clear) {
        this.field = field;
        this.clear = clear;
    }

    public ValueRange range() {
        return this.field.range();
    }

    public ValueRange range(Temporal date) {
        return date.range(this.field);
    }

    public int get(Temporal date) {
        return date.get(this.field);
    }

    public <T extends Temporal> T add(T date, long amount) {
        return this.field.getBaseUnit().addTo(date, amount);
    }

    public <T extends Temporal> T clearToMin(T date) {
        for (ChronoField clearField : this.clear) {
            date = clearField.adjustInto(date, date.range(clearField).getMinimum());
        }
        return date;
    }

    public <T extends Temporal> T clearToMax(T date) {
        return NANOS.add(this.clearToMin(this.add(date, 1L)), -1L);
    }
}

