/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.Help;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.util.Iterables;

@Help(omit=true)
public class AndFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private final List<Filter> filters;

    public AndFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public AndFilter(List<Filter> filters) {
        this.filters = filters;
    }

    public static boolean isAll(Filter filter) {
        return filter instanceof AndFilter && ((AndFilter)filter).isEmpty();
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "*:*";
        }
        return "(" + Iterables.join(" && ", this.filters) + ")";
    }

    public boolean isEmpty() {
        return this.filters.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndFilter that = (AndFilter)o;
        return Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters) + 1;
    }

    @Override
    public PropertyVisitor visit(Scope scope, PropertyVisitor visitor) {
        for (Filter filter : this.filters) {
            filter.visit(scope, visitor);
        }
        return visitor;
    }
}

