/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.FilterCopier;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.Segment;

public class FilterOptimizer
extends FilterCopier {
    private static FilterOptimizer DEFAULT = new FilterOptimizer();

    public static Filter optimize(Filter filter) throws PipeException {
        return (Filter)DEFAULT.visit(filter);
    }

    @Override
    public List<Segment> copySegments(List<Segment> segments) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        Segment buffer = null;
        int questions = 0;
        for (Segment segment : segments) {
            if (segment instanceof Segment.Question) {
                ++questions;
                continue;
            }
            if (segment instanceof Segment.Star) {
                buffer = segment;
                continue;
            }
            this.flushBuffer(result, buffer, questions);
            questions = 0;
            buffer = null;
            result.add(segment);
        }
        this.flushBuffer(result, buffer, questions);
        return result;
    }

    private void flushBuffer(List<Segment> result, Segment buffer, int questions) {
        while (questions-- > 0) {
            result.add(new Segment.Question());
        }
        if (buffer != null) {
            result.add(buffer);
        }
    }

    @Override
    public Filter visitNot(NotFilter filter) throws PipeException {
        Filter child = (Filter)this.visit(filter.filter());
        if (AndFilter.isAll(child)) {
            return (Filter)this.visit(new OrFilter(new Filter[0]));
        }
        if (OrFilter.isNone(child)) {
            return (Filter)this.visit(new AndFilter(new Filter[0]));
        }
        if (child instanceof NotFilter) {
            return ((NotFilter)child).filter();
        }
        return super.visitNot(filter);
    }

    @Override
    public Filter visitAnd(AndFilter filter) throws PipeException {
        LinkedHashSet<Filter> result = new LinkedHashSet<Filter>();
        if (!this.visitAndChildren(result, this.visitList(filter.filters()))) {
            return new OrFilter(new Filter[0]);
        }
        if (result.size() == 1) {
            return (Filter)result.iterator().next();
        }
        return new AndFilter(new ArrayList<Filter>(result));
    }

    @Override
    public Filter visitOr(OrFilter filter) throws PipeException {
        LinkedHashSet<Filter> result = new LinkedHashSet<Filter>();
        if (!this.visitOrChildren(result, this.visitList(filter.filters()))) {
            return new AndFilter(new Filter[0]);
        }
        if (result.size() == 1) {
            return (Filter)result.iterator().next();
        }
        return new OrFilter(new ArrayList<Filter>(result));
    }

    private boolean visitAndChildren(Set<Filter> result, List<Filter> children) {
        for (Filter child : children) {
            if (OrFilter.isNone(child)) {
                return false;
            }
            if (child instanceof AndFilter) {
                this.visitAndChildren(result, ((AndFilter)child).filters());
                continue;
            }
            result.add(child);
        }
        return true;
    }

    private boolean visitOrChildren(Set<Filter> result, List<Filter> children) {
        for (Filter child : children) {
            if (AndFilter.isAll(child)) {
                return false;
            }
            if (child instanceof OrFilter) {
                this.visitOrChildren(result, ((OrFilter)child).filters());
                continue;
            }
            result.add(child);
        }
        return true;
    }
}

