/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.filters.AndFilter;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.NotFilter;
import net.intelie.pipes.filters.OrFilter;
import net.intelie.pipes.filters.TermFilter;

public abstract class FilterVisitor<T> {
    public static final Object INVALID = new Object();

    public T visit(Filter filter) throws PipeException {
        Object obj = this.tryVisit(filter);
        PipeException.check(obj != INVALID, "Unknown filter type: '%s'", filter);
        return (T)obj;
    }

    public Object tryVisit(Filter filter) throws PipeException {
        if (filter == null) {
            return null;
        }
        if (filter instanceof AndFilter) {
            return this.visitAnd((AndFilter)filter);
        }
        if (filter instanceof OrFilter) {
            return this.visitOr((OrFilter)filter);
        }
        if (filter instanceof NotFilter) {
            return this.visitNot((NotFilter)filter);
        }
        if (filter instanceof TermFilter) {
            return this.visitAutomaton((TermFilter)filter);
        }
        return INVALID;
    }

    public List<T> visitList(List<Filter> filters) throws PipeException {
        ArrayList<T> list = new ArrayList<T>();
        for (Filter filter : filters) {
            list.add(this.visit(filter));
        }
        return list;
    }

    public abstract T visitNot(NotFilter var1) throws PipeException;

    public abstract T visitOr(OrFilter var1) throws PipeException;

    public abstract T visitAutomaton(TermFilter var1) throws PipeException;

    public abstract T visitAnd(AndFilter var1) throws PipeException;
}

