/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.io.Serializable;
import java.util.Objects;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;

public interface Segment
extends Serializable {

    public static class Question
    implements Segment {
        private static final long serialVersionUID = 1L;

        public String toString() {
            return "?";
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 65443244;
        }
    }

    public static class Star
    implements Segment {
        private static final long serialVersionUID = 1L;

        public static boolean isStarOnly(Segment ... segments) {
            return segments != null && segments.length == 1 && segments[0].getClass() == Star.class;
        }

        public String toString() {
            return "*";
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 231022;
        }
    }

    public static class Range
    implements Segment {
        private static final long serialVersionUID = 1L;
        private final Object lower;
        private final Object upper;
        private final boolean includesLower;
        private final boolean includesUpper;

        public Range(Object lower, Object upper, boolean includesLower, boolean includesUpper) {
            this.lower = lower;
            this.upper = upper;
            this.includesLower = includesLower;
            this.includesUpper = includesUpper;
        }

        public boolean includesLower() {
            return this.includesLower;
        }

        public boolean includesUpper() {
            return this.includesUpper;
        }

        public Object lower() {
            return this.lower;
        }

        public Object upper() {
            return this.upper;
        }

        private String repr(Object value) {
            return value == null ? "*" : Escapes.formatUnquotedString(Type.STRING.cast(value));
        }

        public String toString() {
            return (this.includesLower ? "[" : "(") + this.repr(this.lower) + ", " + this.repr(this.upper) + (this.includesUpper ? "]" : ")");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range that = (Range)o;
            return Objects.equals(this.lower, that.lower) && Objects.equals(this.upper, that.upper) && Objects.equals(this.includesLower, that.includesLower) && Objects.equals(this.includesUpper, that.includesUpper);
        }

        public int hashCode() {
            return Objects.hash(1L, this.lower, this.upper, this.includesLower, this.includesUpper);
        }
    }

    public static class Fuzzy
    implements Segment {
        private static final long serialVersionUID = 1L;
        private final Object value;
        private final int maxEdits;

        public Fuzzy(Object value, int maxEdits) {
            this.value = value;
            this.maxEdits = maxEdits;
        }

        public Object value() {
            return this.value;
        }

        public int maxEdits() {
            return this.maxEdits;
        }

        public String toString() {
            return Escapes.formatUnquotedString(Type.STRING.cast(this.value)) + "~" + this.maxEdits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fuzzy that = (Fuzzy)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.maxEdits, that.maxEdits);
        }

        public int hashCode() {
            return Objects.hash(1L, this.value, this.maxEdits);
        }
    }

    public static class Literal
    implements Segment {
        private static final long serialVersionUID = 1L;
        private final Object value;

        public Literal(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        public String toString() {
            return Escapes.formatUnquotedString(Type.STRING.cast(this.value));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Literal that = (Literal)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

