/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyGroup;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.filters.Segment;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;

@Help(omit=true)
public class TermFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private final PropertyGroup property;
    private final List<Segment> segments;

    public TermFilter(PropertyGroup property, Segment ... segments) {
        this(property, Arrays.asList(segments));
    }

    public TermFilter(PropertyGroup property, List<Segment> segments) {
        this.property = property;
        this.segments = segments;
    }

    public static TermFilter escaped(PropertyGroup property, String escaped) throws PipeException {
        return new TermFilter(property, Escapes.unescapeWildcard(escaped));
    }

    public static TermFilter literal(PropertyGroup property, Object literal) {
        return new TermFilter(property, new Segment.Literal(literal));
    }

    public static TermFilter fuzzy(PropertyGroup property, Object literal, int edits) {
        return new TermFilter(property, new Segment.Fuzzy(literal, edits));
    }

    public static TermFilter range(PropertyGroup property, Object lower, Object upper) {
        return TermFilter.range(property, lower, upper, true, true);
    }

    public static TermFilter range(PropertyGroup property, Object lower, Object upper, boolean includesLower, boolean includesUpper) {
        return new TermFilter(property, new Segment.Range(lower, upper, includesLower, includesUpper));
    }

    public static TermFilter escaped(Property property, String escaped) throws PipeException {
        return TermFilter.escaped(new PropertyGroup(property), escaped);
    }

    public static TermFilter literal(Property property, Object literal) {
        return TermFilter.literal(new PropertyGroup(property), literal);
    }

    public static TermFilter fuzzy(Property property, Object literal, int edits) {
        return TermFilter.fuzzy(new PropertyGroup(property), literal, edits);
    }

    public static TermFilter range(Property property, Object lower, Object upper) {
        return TermFilter.range(new PropertyGroup(property), lower, upper);
    }

    public static TermFilter range(Property property, Object lower, Object upper, boolean includesLower, boolean includesUpper) {
        return TermFilter.range(new PropertyGroup(property), lower, upper, includesLower, includesUpper);
    }

    public String toString() {
        return this.property.toString() + ":" + this.segmentsAsString();
    }

    public Type type() {
        return this.property.type();
    }

    public PropertyGroup property() {
        return this.property;
    }

    public List<Segment> segments() {
        return this.segments;
    }

    public String segmentsAsString() {
        return Iterables.join("+", this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermFilter that = (TermFilter)o;
        return Objects.equals(this.property, that.property) && Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.segments);
    }

    @Override
    public PropertyVisitor visit(Scope scope, PropertyVisitor visitor) {
        return this.property.visit(scope, visitor);
    }
}

