/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.CompositeSpan;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodSpan;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class AfterSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Period periods;

    public AfterSpan(TimeSpan span) {
        this(span, null);
    }

    public AfterSpan(TimeSpan span, Period periods) {
        super((periods != null ? periods + " " : "") + "after $1", span = AfterSpan.checkSpan(span));
        this.periods = periods;
        this.span = span;
    }

    private static TimeSpan checkSpan(TimeSpan span) {
        Preconditions.checkNotNull(span, "span");
        return span instanceof CompositeSpan ? ((CompositeSpan)span).endSpan() : span;
    }

    @Override
    public AfterSpan forceZone(ZoneId zone) {
        return new AfterSpan(AfterSpan.forceZone(this.span, zone), AfterSpan.forceZone(this.periods, zone));
    }

    @Override
    public long start(long reference) {
        return this.span.end(reference);
    }

    public static AfterSpan tomorrow(ZoneId zone) {
        return AfterSpan.coming(new SimplePeriod(1, PeriodUnit.DAY, zone));
    }

    public static AfterSpan coming(SimplePeriod period) {
        return new AfterSpan(new PeriodSpan(period.unitary()), period);
    }

    @Override
    public long end(long reference) {
        reference = this.span.end(reference);
        if (this.periods != null) {
            reference = this.periods.add(reference);
        }
        return reference;
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.periods == null;
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AfterSpan)) {
            return false;
        }
        AfterSpan that = (AfterSpan)o;
        return Objects.equals(this.span, that.span) && Objects.equals(this.periods, that.periods);
    }

    public int hashCode() {
        return Objects.hash(this.span, this.periods);
    }
}

