/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.time.Where;
import net.intelie.pipes.util.Preconditions;

public class AlignSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Where where;
    private final TimeSpan refSpan;

    public AlignSpan(TimeSpan span, Where where, TimeSpan refSpan) {
        super("$1 aligned " + Preconditions.checkNotNull(where, "where").toString().toLowerCase(Locale.ROOT) + " to $2", Preconditions.checkNotNull(span, "span"), Preconditions.checkNotNull(refSpan, "refSpan"));
        this.refSpan = refSpan;
        this.span = span;
        this.where = where;
    }

    @Override
    public AlignSpan forceZone(ZoneId zone) {
        return new AlignSpan(AlignSpan.forceZone(this.span, zone), this.where, AlignSpan.forceZone(this.refSpan, zone));
    }

    @Override
    public long start(long reference) {
        if (this.where == Where.LEFT) {
            return this.refSpan.start(reference);
        }
        return this.refSpan.end(reference) - this.length(reference);
    }

    @Override
    public long end(long reference) {
        if (this.where == Where.LEFT) {
            return this.refSpan.start(reference) + this.length(reference);
        }
        return this.refSpan.end(reference);
    }

    private long length(long reference) {
        return this.span.end(reference) - this.span.start(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return this.refSpan.includesPresent() && (this.where == Where.RIGHT || this.where == Where.LEFT && this.refSpan.isPoint());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlignSpan)) {
            return false;
        }
        AlignSpan that = (AlignSpan)o;
        return Objects.equals((Object)this.where, (Object)that.where) && Objects.equals(this.refSpan, that.refSpan) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.where, this.refSpan, this.span});
    }
}

