/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.SpanAnnotations;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class AnnotatedSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final SpanAnnotations annotations;

    public AnnotatedSpan(TimeSpan span, SpanAnnotations annotations) {
        super((annotations.size() > 0 ? "$1 " : "$1") + annotations, Preconditions.checkNotNull(span, "span"));
        this.span = span;
        this.annotations = annotations;
    }

    @Override
    public AnnotatedSpan forceZone(ZoneId zone) {
        return new AnnotatedSpan(AnnotatedSpan.forceZone(this.span, zone), this.annotations);
    }

    @Override
    public long start(long reference) {
        return this.span.start(reference);
    }

    @Override
    public long end(long reference) {
        return this.span.end(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent();
    }

    @Override
    public SpanAnnotations annotations() {
        return this.annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotatedSpan)) {
            return false;
        }
        AnnotatedSpan that = (AnnotatedSpan)o;
        return Objects.equals(this.span, that.span) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.span, this.annotations);
    }
}

