/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class CompositeSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan startSpan;
    private final TimeSpan endSpan;

    public CompositeSpan(TimeSpan startSpan, TimeSpan endSpan) {
        super(startSpan == null ? "until $2" : (endSpan == null ? "since $1" : "from $1 to $2"), startSpan, endSpan);
        Preconditions.checkArgument(startSpan != null || endSpan != null, "Both startSpan and endSpan are null.");
        this.startSpan = startSpan;
        this.endSpan = endSpan;
    }

    @Override
    public CompositeSpan forceZone(ZoneId zone) {
        return new CompositeSpan(CompositeSpan.forceZone(this.startSpan, zone), CompositeSpan.forceZone(this.endSpan, zone));
    }

    public TimeSpan startSpan() {
        Preconditions.checkState(this.startSpan != null, "The selected composite span has no startSpan");
        return this.startSpan;
    }

    public TimeSpan endSpan() {
        Preconditions.checkState(this.endSpan != null, "The selected composite span has no endSpan");
        return this.endSpan;
    }

    @Override
    public long start(long reference) {
        if (this.startSpan == null) {
            return 0L;
        }
        return this.startSpan.start(reference);
    }

    @Override
    public long end(long reference) {
        if (this.endSpan == null) {
            return reference;
        }
        return this.endSpan.end(reference);
    }

    @Override
    public boolean isFixed() {
        return (this.startSpan == null || this.startSpan.isFixed()) && this.endSpan != null && this.endSpan.isFixed();
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean includesPresent() {
        return this.endSpan == null || this.endSpan.includesPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeSpan)) {
            return false;
        }
        CompositeSpan that = (CompositeSpan)o;
        return Objects.equals(this.startSpan, that.startSpan) && Objects.equals(this.endSpan, that.endSpan);
    }

    public int hashCode() {
        return Objects.hash(this.startSpan, this.endSpan);
    }
}

