/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.cron.Cron;
import net.intelie.pipes.time.MultiplyPeriod;
import net.intelie.pipes.time.Period;

public class CronPeriod
implements Period {
    private static final long serialVersionUID = 1L;
    private final Cron cron;
    private final String expression;
    private final ZoneId zone;

    public CronPeriod(String expression) {
        this(expression, null);
    }

    public CronPeriod(String expression, ZoneId zone) {
        this(new Cron(expression), expression, zone);
    }

    private CronPeriod(Cron cron, String expression, ZoneId zone) {
        this.cron = cron;
        this.expression = expression;
        this.zone = zone == null ? ZoneId.systemDefault() : zone;
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", this.expression);
        map.put("unit", "cron");
        map.put("zone", this.zone.getId());
        return map;
    }

    @Override
    public CronPeriod forceZone(ZoneId zone) {
        return new CronPeriod(this.cron, this.expression, zone);
    }

    @Override
    public String toString(boolean includeOne) {
        return "cron('" + this.expression + "')";
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public long add(long timestamp) {
        return this.toLong(this.cron.next(this.toDate(timestamp)));
    }

    @Override
    public long sub(long timestamp) {
        return this.toLong(this.cron.prev(this.toDate(timestamp)));
    }

    @Override
    public long floor(long timestamp) {
        return this.toLong(this.cron.prevOrSame(this.toDate(timestamp)));
    }

    private long toLong(ZonedDateTime date) {
        if (date == null) {
            return Long.MAX_VALUE;
        }
        return date.toInstant().toEpochMilli();
    }

    private ZonedDateTime toDate(long timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.zone);
    }

    @Override
    public boolean supportsFloor() {
        return true;
    }

    @Override
    public long estimateMillis() {
        return this.add(1400000000000L) - this.floor(1400000000000L);
    }

    @Override
    public Period multiply(int amount) {
        if (amount == 1) {
            return this;
        }
        return new MultiplyPeriod(amount, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CronPeriod)) {
            return false;
        }
        CronPeriod that = (CronPeriod)o;
        return Objects.equals(this.cron, that.cron) && Objects.equals(this.zone, that.zone);
    }

    public int hashCode() {
        return Objects.hash(this.cron, this.zone);
    }
}

