/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.intelie.pipes.time.Clock;
import net.intelie.pipes.time.ManualSchedulerContext;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.SchedulerContext;
import net.intelie.pipes.time.Task;
import net.intelie.pipes.time.TaskHandle;

public class DefaultSchedulerContext
implements SchedulerContext {
    private final ManualSchedulerContext context = new ManualSchedulerContext();
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final long offset;
    private ScheduledFuture<?> future;
    private long expectedNext;
    private boolean executingTasks;

    public DefaultSchedulerContext(ScheduledExecutorService executor, Clock clock) {
        this(executor, clock, 0L);
    }

    public DefaultSchedulerContext(ScheduledExecutorService executor, Clock clock, long offset) {
        this.executor = executor;
        this.clock = clock;
        this.offset = offset;
        this.expectedNext = Long.MAX_VALUE;
    }

    @Override
    public synchronized TaskHandle schedule(Period period, Task runnable) {
        final ManualSchedulerContext.DefaultTaskHandle handle = this.context.scheduleAt(period, runnable, this.clock.now());
        this.rescheduleNext();
        return new TaskHandle(){

            @Override
            public long nextTimestamp() {
                return handle.nextTimestamp();
            }

            @Override
            public void cancel() {
                handle.cancel();
                DefaultSchedulerContext.this.rescheduleNext();
            }
        };
    }

    @Override
    public long now() {
        return this.clock.now() + this.offset;
    }

    @Override
    public boolean started() {
        return this.context.started();
    }

    @Override
    public long startTime() {
        return this.context.startTime();
    }

    @Override
    public long nextTaskTimestamp() {
        return this.expectedNext;
    }

    @Override
    public synchronized void cancelAll() {
        this.context.cancelAll();
        this.rescheduleNext();
    }

    @Override
    public synchronized void start() {
        this.context.advanceTo(this.now());
        this.context.start();
        this.scheduleNext();
    }

    private synchronized void rescheduleNext() {
        if (this.executingTasks) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.scheduleNext();
    }

    private void scheduleNext() {
        assert (Thread.holdsLock(this));
        long now = this.now();
        this.expectedNext = this.context.nextTaskTimestamp();
        long next = this.expectedNext;
        if (next == Long.MAX_VALUE) {
            return;
        }
        this.future = this.executor.schedule(() -> this.executeNext(next), Math.max(next - now, 0L), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext(long next) {
        DefaultSchedulerContext defaultSchedulerContext = this;
        synchronized (defaultSchedulerContext) {
            if (this.executingTasks || next != this.expectedNext) {
                return;
            }
            this.executingTasks = true;
        }
        try {
            assert (!Thread.holdsLock(this));
            this.context.advanceTo(next);
        }
        finally {
            defaultSchedulerContext = this;
            synchronized (defaultSchedulerContext) {
                this.executingTasks = false;
                this.scheduleNext();
            }
        }
    }
}

