/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.time.Where;
import net.intelie.pipes.util.Preconditions;

public class ExtendSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Where where;
    private final Period iterable;

    public ExtendSpan(TimeSpan span, Where where, Period iterable) {
        super("$1 extended " + Preconditions.checkNotNull(where, "where").toString().toLowerCase(Locale.ROOT) + " by " + Preconditions.checkNotNull(iterable, "iterable"), Preconditions.checkNotNull(span, "span"));
        this.span = span;
        this.where = where;
        this.iterable = iterable;
    }

    @Override
    public ExtendSpan forceZone(ZoneId zone) {
        return new ExtendSpan(ExtendSpan.forceZone(this.span, zone), this.where, ExtendSpan.forceZone(this.iterable, zone));
    }

    @Override
    public long start(long reference) {
        long start = this.span.start(reference);
        if (this.where == Where.LEFT) {
            start = this.iterable.sub(start);
        }
        return start;
    }

    @Override
    public long end(long reference) {
        long end = this.span.end(reference);
        if (this.where == Where.RIGHT) {
            end = this.iterable.add(end);
        }
        return end;
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendSpan)) {
            return false;
        }
        ExtendSpan that = (ExtendSpan)o;
        return Objects.equals((Object)this.where, (Object)that.where) && Objects.equals(this.iterable, that.iterable) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.where, this.iterable, this.span});
    }
}

