/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.util.Preconditions;

public class MultiplyPeriod
implements Period {
    private static final long serialVersionUID = 1L;
    private final int amount;
    private final Period period;

    public MultiplyPeriod(int amount, Period period) {
        this.amount = amount;
        this.period = period;
    }

    @Override
    public boolean supportsFloor() {
        return this.amount == 1 && this.period.supportsFloor();
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "multiply");
        map.put("amount", Double.valueOf(this.amount));
        map.put("value", this.period.simple());
        return map;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeOne) {
        if (!includeOne && this.amount == 1) {
            return this.period.toString(false);
        }
        return this.amount + "*(" + this.period + ")";
    }

    @Override
    public MultiplyPeriod forceZone(ZoneId zone) {
        return new MultiplyPeriod(this.amount, this.period.forceZone(zone));
    }

    @Override
    public Period multiply(int amount) {
        return new MultiplyPeriod(this.amount * amount, this.period);
    }

    @Override
    public long add(long timestamp) {
        int i;
        for (i = 0; i < this.amount; ++i) {
            timestamp = this.period.add(timestamp);
        }
        for (i = 0; i < -this.amount; ++i) {
            timestamp = this.period.sub(timestamp);
        }
        return timestamp;
    }

    @Override
    public long sub(long timestamp) {
        int i;
        for (i = 0; i < this.amount; ++i) {
            timestamp = this.period.sub(timestamp);
        }
        for (i = 0; i < -this.amount; ++i) {
            timestamp = this.period.add(timestamp);
        }
        return timestamp;
    }

    @Override
    public long floor(long timestamp) {
        Preconditions.checkArgument(this.supportsFloor(), "PeriodList with multiple periods doesn't support 'floor' operation.");
        return this.period.floor(timestamp);
    }

    @Override
    public long estimateMillis() {
        return (long)this.amount * this.period.estimateMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiplyPeriod)) {
            return false;
        }
        MultiplyPeriod that = (MultiplyPeriod)o;
        return Objects.equals(this.amount, that.amount) && Objects.equals(this.period, that.period);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.period);
    }
}

