/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.intelie.pipes.time.Clock;
import net.intelie.pipes.time.ClockScheduler;
import net.intelie.pipes.time.ManualSchedulerContext;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.SchedulerContext;
import net.intelie.pipes.time.SystemClock;
import net.intelie.pipes.time.Task;
import net.intelie.pipes.time.TaskAction;
import net.intelie.pipes.time.TaskHandle;
import net.intelie.pipes.time.TaskRunner;

public class OrderedScheduler
implements ClockScheduler {
    private final List<MyContext> contexts = new ArrayList<MyContext>();
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final TaskRunner runner;
    private ScheduledFuture<?> future;
    private List<TaskAction> actionsBuffer;
    private volatile long expectedNext = Long.MAX_VALUE;
    private boolean executingTasks;

    public OrderedScheduler() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    public OrderedScheduler(ScheduledExecutorService executor) {
        this(executor, new SystemClock());
    }

    public OrderedScheduler(ScheduledExecutorService executor, Clock clock) {
        this(executor, clock, null);
    }

    public OrderedScheduler(ScheduledExecutorService executor, Clock clock, TaskRunner runner) {
        this.runner = runner != null ? runner : new TaskRunner.Default();
        this.executor = executor;
        this.clock = clock;
    }

    private void rescheduleNext() {
        if (this.executingTasks) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.scheduleNext();
    }

    public synchronized void cancelAll() {
        while (!this.contexts.isEmpty()) {
            this.contexts.get(0).cancelAll();
        }
    }

    private void scheduleNext() {
        assert (Thread.holdsLock(this));
        long now = this.clock.now();
        this.expectedNext = this.nextTaskTimestamp();
        long next = this.expectedNext;
        if (next == Long.MAX_VALUE) {
            return;
        }
        this.future = this.executor.schedule(() -> this.executeNext(next), Math.max(next - now, 0L), TimeUnit.MILLISECONDS);
    }

    private long nextTaskTimestamp() {
        long next = Long.MAX_VALUE;
        for (MyContext context : this.contexts) {
            next = Math.min(next, context.nextTaskTimestamp());
        }
        return next;
    }

    public long currentTaskTimestamp() {
        return this.expectedNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext(long next) {
        List<TaskAction> bufferCopy;
        OrderedScheduler orderedScheduler = this;
        synchronized (orderedScheduler) {
            if (this.executingTasks || next != this.expectedNext) {
                return;
            }
            this.actionsBuffer = new ArrayList<TaskAction>();
            for (MyContext context : this.contexts) {
                context.advanceTo(next);
            }
            bufferCopy = this.actionsBuffer;
            this.actionsBuffer = null;
            this.executingTasks = true;
        }
        try {
            this.runner.onTasks(next, bufferCopy);
            assert (!Thread.holdsLock(this));
        }
        finally {
            orderedScheduler = this;
            synchronized (orderedScheduler) {
                this.executingTasks = false;
                this.scheduleNext();
            }
        }
    }

    @Override
    public SchedulerContext newContext() {
        return new MyContext();
    }

    @Override
    public long now() {
        return this.clock.now();
    }

    private class MyContext
    implements SchedulerContext {
        private final ManualSchedulerContext context = new ManualSchedulerContext((timestamp, actions) -> OrderedScheduler.this.actionsBuffer.addAll(actions));

        private MyContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskHandle schedule(Period period, Task runnable) {
            TaskHandle result;
            OrderedScheduler orderedScheduler = OrderedScheduler.this;
            synchronized (orderedScheduler) {
                final ManualSchedulerContext.DefaultTaskHandle handle = this.context.schedule(period, runnable);
                if (this.context.started()) {
                    OrderedScheduler.this.rescheduleNext();
                }
                result = new TaskHandle(){

                    @Override
                    public long nextTimestamp() {
                        return handle.nextTimestamp();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void cancel() {
                        OrderedScheduler orderedScheduler = OrderedScheduler.this;
                        synchronized (orderedScheduler) {
                            handle.cancel();
                            if (MyContext.this.context.started()) {
                                OrderedScheduler.this.rescheduleNext();
                            }
                        }
                    }
                };
            }
            return result;
        }

        @Override
        public long now() {
            return this.context.now();
        }

        @Override
        public boolean started() {
            return this.context.started();
        }

        @Override
        public long startTime() {
            return this.context.startTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            OrderedScheduler orderedScheduler = OrderedScheduler.this;
            synchronized (orderedScheduler) {
                this.context.advanceTo(OrderedScheduler.this.clock.now());
                this.context.start();
                OrderedScheduler.this.contexts.add(this);
                OrderedScheduler.this.rescheduleNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelAll() {
            OrderedScheduler orderedScheduler = OrderedScheduler.this;
            synchronized (orderedScheduler) {
                OrderedScheduler.this.contexts.remove(this);
                this.context.cancelAll();
                OrderedScheduler.this.rescheduleNext();
            }
        }

        @Override
        public long nextTaskTimestamp() {
            return this.context.nextTaskTimestamp();
        }

        public void advanceTo(long next) {
            this.context.advanceTo(next);
        }
    }
}

