/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.Serializable;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.util.Preconditions;

public class PeriodIterator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Period adder;
    private final boolean aligned;
    private volatile long begin;
    private volatile long end;

    public PeriodIterator(long now, boolean aligned, Period adder) {
        Preconditions.checkArgument(!aligned || adder.supportsFloor(), "PeriodList with multiple periods doesn't support aligned iteration");
        this.adder = adder;
        this.aligned = aligned;
        this.begin = aligned ? adder.floor(now) : now;
        this.end = adder.add(this.begin);
    }

    public long begin() {
        return this.begin;
    }

    public long end() {
        return this.end;
    }

    public void moveNext() {
        this.begin = this.end;
        this.end = this.adder.add(this.end);
        if (this.aligned) {
            this.end = this.adder.floor(this.end);
        }
    }

    public void movePrev() {
        this.end = this.begin;
        this.begin = this.adder.sub(this.begin);
        if (this.aligned) {
            this.begin = this.adder.floor(this.begin);
        }
    }
}

