/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class PeriodList
implements Period {
    private final List<? extends Period> periods;

    public PeriodList(Period ... periods) {
        this(Arrays.asList(periods));
    }

    public PeriodList(List<? extends Period> periods) {
        Preconditions.checkArgument(periods.size() > 0, "PeriodList must have at least one period");
        this.periods = periods;
    }

    public static Period of(Period ... periods) {
        return PeriodList.of(Arrays.asList(periods));
    }

    public static Period of(List<? extends Period> periods) {
        if (periods.size() == 1) {
            return periods.iterator().next();
        }
        return new PeriodList(periods);
    }

    @Override
    public PeriodList forceZone(ZoneId zone) {
        return new PeriodList(this.periods.stream().map(x -> x.forceZone(zone)).collect(Collectors.toList()));
    }

    @Override
    public Map<String, Object> simple() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.periods.size());
        for (Period period : this.periods) {
            list.add(period.simple());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "list");
        map.put("value", list);
        return map;
    }

    @Override
    public long add(long timestamp) {
        for (Period period : this.periods) {
            timestamp = period.add(timestamp);
        }
        return timestamp;
    }

    @Override
    public long sub(long timestamp) {
        for (Period period : this.periods) {
            timestamp = period.sub(timestamp);
        }
        return timestamp;
    }

    @Override
    public long floor(long timestamp) {
        Preconditions.checkArgument(this.supportsFloor(), "PeriodList with multiple periods doesn't support 'floor' operation.");
        return this.periods.get(0).floor(timestamp);
    }

    @Override
    public boolean supportsFloor() {
        return this.periods.size() == 1 && this.periods.get(0).supportsFloor();
    }

    @Override
    public long estimateMillis() {
        long sum = 0L;
        for (Period period : this.periods) {
            sum += period.estimateMillis();
        }
        return sum;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public PeriodList multiply(int amount) {
        ArrayList<Period> newPeriods = new ArrayList<Period>(this.periods.size());
        for (Period period : this.periods) {
            newPeriods.add(period.multiply(amount));
        }
        return new PeriodList(newPeriods);
    }

    @Override
    public String toString(boolean includeOne) {
        if (this.periods.size() == 1) {
            return this.periods.get(0).toString(includeOne);
        }
        return Iterables.joinWithLast(", ", " and ", this.periods);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeriodList)) {
            return false;
        }
        PeriodList that = (PeriodList)o;
        return Objects.equals(this.periods, that.periods);
    }

    public int hashCode() {
        return Objects.hash(this.periods);
    }
}

