/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.intelie.pipes.time.CalendarPeriodBase;
import net.intelie.pipes.time.LongPeriodBase;
import net.intelie.pipes.time.PeriodBase;
import net.intelie.pipes.util.Preconditions;

public enum PeriodUnit implements Serializable
{
    MILLISECOND{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new LongPeriodBase(quantity);
        }
    }
    ,
    SECOND{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new LongPeriodBase((long)quantity * 1000L);
        }
    }
    ,
    MINUTE{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new LongPeriodBase((long)quantity * 1000L * 60L);
        }
    }
    ,
    HOUR{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new LongPeriodBase((long)quantity * 1000L * 60L * 60L);
        }
    }
    ,
    DAY{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(quantity, ChronoField.DAY_OF_MONTH, zone);
        }
    }
    ,
    WEEK{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(quantity, ChronoField.ALIGNED_WEEK_OF_YEAR, zone);
        }
    }
    ,
    MONTH{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(quantity, ChronoField.MONTH_OF_YEAR, zone);
        }
    }
    ,
    BIMESTER{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(2 * quantity, ChronoField.MONTH_OF_YEAR, zone);
        }
    }
    ,
    QUARTER{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(3 * quantity, ChronoField.MONTH_OF_YEAR, zone);
        }
    }
    ,
    SEMESTER{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(6 * quantity, ChronoField.MONTH_OF_YEAR, zone);
        }
    }
    ,
    YEAR{

        @Override
        public PeriodBase create(int quantity, ZoneId zone) {
            return new CalendarPeriodBase(quantity, ChronoField.YEAR, zone);
        }
    };

    private static final long serialVersionUID = 1L;
    private static final Map<String, PeriodUnit> units;

    private static void put(Map<String, PeriodUnit> units, PeriodUnit unit, String ... names) {
        for (String name : names) {
            units.put(name, unit);
            units.put(name + "s", unit);
        }
    }

    public static PeriodUnit fromNameSafe(String name) {
        return units.get(name);
    }

    public static PeriodUnit fromName(String name) {
        PeriodUnit unit = PeriodUnit.fromNameSafe(name);
        Preconditions.checkArgument(unit != null, "Unknown period unit: %s", name);
        return unit;
    }

    public abstract PeriodBase create(int var1, ZoneId var2);

    public String toString(int quantity, boolean includeOne) {
        return (quantity != 1 || includeOne ? quantity + " " : "") + this.name().toLowerCase(Locale.ROOT) + (quantity != 1 ? "s" : "");
    }

    static {
        TreeMap<String, PeriodUnit> temp = new TreeMap<String, PeriodUnit>(String.CASE_INSENSITIVE_ORDER);
        PeriodUnit.put(temp, MILLISECOND, "millisecond", "milli", "ms");
        PeriodUnit.put(temp, SECOND, "sec", "second");
        PeriodUnit.put(temp, MINUTE, "min", "minute");
        PeriodUnit.put(temp, HOUR, "hour");
        PeriodUnit.put(temp, DAY, "day");
        PeriodUnit.put(temp, WEEK, "wk", "week");
        PeriodUnit.put(temp, MONTH, "mon", "month");
        PeriodUnit.put(temp, BIMESTER, "bimester");
        PeriodUnit.put(temp, QUARTER, "quarter");
        PeriodUnit.put(temp, SEMESTER, "semester");
        PeriodUnit.put(temp, YEAR, "yr", "year");
        units = Collections.unmodifiableMap(temp);
    }
}

