/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class PointSpan
extends TimeSpanBase {
    public static final PointSpan NOW = new PointSpan(null);
    private static final long serialVersionUID = 1L;
    private final Period periods;

    public PointSpan(Period periods) {
        super(periods == null ? "now" : Preconditions.checkNotNull(periods, "periods") + " ago", new TimeSpan[0]);
        this.periods = periods;
    }

    @Override
    public PointSpan forceZone(ZoneId zone) {
        return new PointSpan(PointSpan.forceZone(this.periods, zone));
    }

    @Override
    public long start(long reference) {
        if (this.periods != null) {
            reference = this.periods.sub(reference);
        }
        return reference;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public long end(long reference) {
        return this.start(reference);
    }

    @Override
    public boolean isPoint() {
        return true;
    }

    @Override
    public boolean includesPresent() {
        return this.periods == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointSpan)) {
            return false;
        }
        PointSpan that = (PointSpan)o;
        return Objects.equals(this.periods, that.periods);
    }

    public int hashCode() {
        return Objects.hash(this.periods);
    }
}

