/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.time.Where;
import net.intelie.pipes.util.Preconditions;

public class ShiftByPercentSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Where where;
    private final int value;

    public ShiftByPercentSpan(TimeSpan span, Where where, int value) {
        super("$1 shifted " + Preconditions.checkNotNull(where, "where").toString().toLowerCase(Locale.ROOT) + " by " + value + "%", Preconditions.checkNotNull(span, "span"));
        Preconditions.checkArgument(value >= 0, "value must be non-negative");
        this.span = span;
        this.where = where;
        this.value = value;
    }

    @Override
    public ShiftByPercentSpan forceZone(ZoneId zone) {
        return new ShiftByPercentSpan(ShiftByPercentSpan.forceZone(this.span, zone), this.where, this.value);
    }

    @Override
    public long start(long reference) {
        long start = this.span.start(reference);
        long end = this.span.end(reference);
        start = (long)((double)start + (double)(this.where == Where.LEFT ? -1 : 1) * ((double)this.value / 100.0) * (double)Math.max(end - start, 0L));
        return start;
    }

    @Override
    public long end(long reference) {
        long start = this.span.start(reference);
        long end = this.span.end(reference);
        end = (long)((double)end + (double)(this.where == Where.LEFT ? -1 : 1) * ((double)this.value / 100.0) * (double)Math.max(end - start, 0L));
        return end;
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShiftByPercentSpan)) {
            return false;
        }
        ShiftByPercentSpan that = (ShiftByPercentSpan)o;
        return Objects.equals((Object)this.where, (Object)that.where) && Objects.equals(this.value, that.value) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.where, this.value, this.span});
    }
}

