/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.time.Where;
import net.intelie.pipes.util.Preconditions;

public class ShiftBySpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final Period period;
    private final TimeSpan span;
    private final Where where;

    public ShiftBySpan(TimeSpan span, Where where, Period period) {
        super("$1 shifted " + Preconditions.checkNotNull(where, "where").toString().toLowerCase(Locale.ROOT) + " by " + Preconditions.checkNotNull(period, "period"), Preconditions.checkNotNull(span, "span"));
        this.period = period;
        this.span = span;
        this.where = where;
    }

    @Override
    public ShiftBySpan forceZone(ZoneId zone) {
        return new ShiftBySpan(ShiftBySpan.forceZone(this.span, zone), this.where, ShiftBySpan.forceZone(this.period, zone));
    }

    @Override
    public long start(long reference) {
        reference = this.span.start(reference);
        return this.where == Where.LEFT ? this.period.sub(reference) : this.period.add(reference);
    }

    @Override
    public long end(long reference) {
        reference = this.span.end(reference);
        return this.where == Where.LEFT ? this.period.sub(reference) : this.period.add(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShiftBySpan)) {
            return false;
        }
        ShiftBySpan that = (ShiftBySpan)o;
        return Objects.equals(this.period, that.period) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.span);
    }
}

