/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;

public class SpanAnnotations
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TRUE = "true";
    private final Map<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public SpanAnnotations() {
        this(Collections.emptyMap());
    }

    public SpanAnnotations(Map<String, String> values) {
        this.values.putAll(values);
    }

    public boolean isTrue(String key) {
        return TRUE.equals(this.get(key));
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public int size() {
        return this.values.size();
    }

    public static SpanAnnotations merge(Iterable<SpanAnnotations> annotations) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (SpanAnnotations annotation : annotations) {
            if (annotation == null) continue;
            values.putAll(annotation.values);
        }
        return new SpanAnnotations(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanAnnotations)) {
            return false;
        }
        SpanAnnotations that = (SpanAnnotations)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            list.add("#" + this.formatString(entry.getKey()) + (!TRUE.equals(entry.getValue()) ? "=" + this.formatString(entry.getValue()) : ""));
        }
        return Iterables.join(" ", list);
    }

    private String formatString(String value) {
        if (Escapes.needsIdentifierFormatting(value)) {
            return "'" + value + "'";
        }
        return value;
    }
}

