/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.intelie.pipes.time.SpanAnnotations;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.util.AutomatonRepr;

public class SpanMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final TimeSpan[] children;
    private final String reprToString;
    private final List<TimeSpan> childrenList;
    private final SpanAnnotations annotations;

    public SpanMetadata(String label, TimeSpan ... children) {
        this.label = label;
        this.children = children;
        this.childrenList = Collections.unmodifiableList(Arrays.asList(children));
        this.annotations = SpanAnnotations.merge(this.childrenList.stream().filter(Objects::nonNull).map(TimeSpan::annotations).collect(Collectors.toList()));
        this.reprToString = SpanMetadata.makeToString(label, children);
    }

    public static String makeToString(String label, TimeSpan ... children) {
        String base = label;
        for (int i = 0; i < children.length; ++i) {
            base = base.replace("$" + (i + 1), "(" + children[i] + ")");
        }
        return base;
    }

    public SpanAnnotations annotations() {
        return this.annotations;
    }

    public List<TimeSpan> children() {
        return this.childrenList;
    }

    public AutomatonRepr repr(TimeSpan span, long timestamp, String zone) {
        AutomatonRepr auto = new AutomatonRepr("start");
        long start = span.start(timestamp);
        long end = span.end(timestamp);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);
        formatter.setTimeZone(TimeZone.getTimeZone(zone));
        auto.addNode("rectangle", "start", this.label + "\\n" + formatter.format(new Date(start)) + "\\n" + formatter.format(new Date(end)));
        for (int i = 0; i < this.children.length; ++i) {
            AutomatonRepr repr;
            if (this.children[i] == null || (repr = this.children[i].repr(timestamp, zone)) == null) continue;
            auto.addEdge("start", "s" + (i + 1) + "_", repr, i + 1);
        }
        return auto;
    }

    public String toString() {
        return this.reprToString;
    }
}

