/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.StringReader;
import java.time.ZoneId;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.generated.ParseExceptionMessage;
import net.intelie.pipes.generated.SimpleCharStream;
import net.intelie.pipes.generated.TimeSpanParserCore;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;

public class TimeSpanParser {
    private final ZoneId defaultTZ;

    public TimeSpanParser() {
        this(ZoneId.systemDefault());
    }

    public TimeSpanParser(ZoneId defaultTZ) {
        this.defaultTZ = defaultTZ;
    }

    public TimeSpan parse(String s) throws PipeException {
        return this.parse(s, null);
    }

    public Period parsePeriod(String s) throws PipeException {
        return this.parsePeriod(s, null);
    }

    public Period parsePeriod(String s, ZoneId zone) throws PipeException {
        TimeSpanParserCore parser = new TimeSpanParserCore(new SimpleCharStream(new StringReader(s)));
        try {
            if (zone == null) {
                zone = this.defaultTZ;
            }
            return parser.startPeriod(zone);
        }
        catch (Throwable e) {
            throw ParseExceptionMessage.handle(e, new SourceLocation(parser.token.beginLine, parser.token.beginColumn));
        }
    }

    public TimeSpan parse(String s, ZoneId zone) throws PipeException {
        TimeSpanParserCore parser = new TimeSpanParserCore(new SimpleCharStream(new StringReader(s)));
        try {
            if (zone == null) {
                zone = this.defaultTZ;
            }
            return parser.start(zone);
        }
        catch (Throwable e) {
            throw ParseExceptionMessage.handle(e, new SourceLocation(parser.token.beginLine, parser.token.beginColumn));
        }
    }
}

