/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class UnionSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final List<TimeSpan> spans;

    public UnionSpan(List<TimeSpan> spans) {
        super(UnionSpan.makeRepr(spans), spans.toArray(new TimeSpan[0]));
        Preconditions.checkArgument(spans.size() > 0, "Must have at least one span.");
        this.spans = spans;
    }

    private static String makeRepr(List<TimeSpan> spans) {
        return "union of " + Iterables.joinWithLast(", ", " and ", IntStream.rangeClosed(1, spans.size()).mapToObj(x -> "$" + x).collect(Collectors.toList()));
    }

    @Override
    public UnionSpan forceZone(ZoneId zone) {
        return new UnionSpan(this.spans.stream().map(x -> x.forceZone(zone)).collect(Collectors.toList()));
    }

    public List<TimeSpan> spans() {
        return Collections.unmodifiableList(this.spans);
    }

    @Override
    public long start(long reference) {
        return this.spans.stream().mapToLong(x -> x.start(reference)).min().orElse(reference);
    }

    @Override
    public long end(long reference) {
        return this.spans.stream().mapToLong(x -> x.end(reference)).max().orElse(reference);
    }

    @Override
    public boolean isFixed() {
        return this.spans.stream().allMatch(TimeSpan::isFixed);
    }

    @Override
    public boolean isPoint() {
        return this.spans.stream().allMatch(TimeSpan::isPoint);
    }

    @Override
    public boolean includesPresent() {
        return this.spans.stream().anyMatch(TimeSpan::includesPresent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnionSpan)) {
            return false;
        }
        UnionSpan that = (UnionSpan)o;
        return Objects.equals(this.spans, that.spans);
    }

    public int hashCode() {
        return Objects.hash(this.spans);
    }
}

