/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.types.WindowSpan;
import net.intelie.pipes.util.Iterables;

public class CompositeInfo
implements WindowInfo {
    private static final long serialVersionUID = 1L;
    private final Set<WindowInfo> infos = new LinkedHashSet<WindowInfo>();

    public CompositeInfo(WindowInfo ... infos) {
        this(Arrays.asList(infos));
    }

    public CompositeInfo(List<WindowInfo> infos) {
        for (WindowInfo info : infos) {
            for (WindowInfo child : info) {
                this.infos.add(child);
            }
        }
    }

    @Override
    public WindowSpan wrap(final TimeSpan span) {
        final ArrayList<WindowSpan> innerSpans = new ArrayList<WindowSpan>();
        for (WindowInfo info : this.infos) {
            innerSpans.add(info.wrap(span));
        }
        return new WindowSpan(span, this){
            private static final long serialVersionUID = 1L;

            @Override
            public long windowStart(long reference) {
                long minn = reference;
                for (WindowSpan span2 : innerSpans) {
                    minn = Math.min(minn, span2.windowStart(reference));
                }
                return minn;
            }

            @Override
            public WindowSpan forceZone(ZoneId zone) {
                return CompositeInfo.this.wrap(span.forceZone(zone));
            }

            @Override
            public boolean isPoint() {
                for (WindowSpan span2 : innerSpans) {
                    if (span2.isPoint()) continue;
                    return false;
                }
                return span.isPoint();
            }
        };
    }

    @Override
    public Iterator<WindowInfo> iterator() {
        return this.infos.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeInfo)) {
            return false;
        }
        CompositeInfo that = (CompositeInfo)o;
        return Objects.equals(this.infos, that.infos);
    }

    public int hashCode() {
        return Objects.hash(this.infos);
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (WindowInfo info : this.infos) {
            String str = info.toString();
            if (str.isEmpty()) continue;
            list.add(str);
        }
        return Iterables.join(", ", list);
    }
}

