/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.OutputType;

public class ItemOutput
implements Output {
    private static final long serialVersionUID = 1L;
    private final int amount;
    private final boolean after;
    private final Aggregation<Boolean> expr;
    private final String exprStr;

    public ItemOutput(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Item amount can not have non-positive amount: " + amount);
        }
        this.amount = amount;
        this.expr = null;
        this.exprStr = null;
        this.after = true;
    }

    public ItemOutput(boolean after, Aggregation<Boolean> expr) {
        this.after = after;
        this.expr = expr;
        this.exprStr = expr.toString();
        this.amount = 1;
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "item");
        if (this.exprStr != null) {
            map.put("expr", this.exprStr);
        } else {
            map.put("amount", Double.valueOf(this.amount));
        }
        return map;
    }

    @Override
    public OutputType type() {
        return OutputType.ITEM;
    }

    public boolean isTransformationOnly() {
        return this.amount == 1 && this.expr == null;
    }

    public int amount() {
        return this.amount;
    }

    public Aggregation<Boolean> expr() {
        return this.expr;
    }

    public boolean after() {
        return this.after;
    }

    public String toString() {
        if (this.exprStr != null) {
            return "every (" + this.exprStr + ")" + (this.after ? "" : " before");
        }
        return "every " + this.amount + (this.amount == 1 ? " item" : " items");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemOutput)) {
            return false;
        }
        ItemOutput that = (ItemOutput)o;
        return Objects.equals(this.amount, that.amount) && Objects.equals(this.exprStr, that.exprStr);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.exprStr);
    }
}

